/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.function;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.function.FeatureFunction;
import org.cleartk.classifier.feature.util.NumericTypeUtil;

public class NumericTypeFeatureFunction
implements FeatureFunction {
    public static final String DEFAULT_NAME = "NumericType";
    static Pattern yearDigitsPattern = Pattern.compile("(?:1[0-9]{3,3})|(?:2[0|1][0-9]{2,2})");
    static Pattern alphanumericPattern = Pattern.compile("[a-zA-Z0-9-]+");
    static Pattern someLetters = Pattern.compile("[a-zA-Z]");
    static Pattern romanNumeralPattern = Pattern.compile("^M?M?M?(CM|CD|D?C?C?C?)(XC|XL|L?X?X?X?)(IX|IV|V?I?I?I?)$");

    public List<Feature> apply(Feature feature) {
        String featureName = Feature.createName(DEFAULT_NAME, feature.getName());
        Object featureValue = feature.getValue();
        if (featureValue == null) {
            return Collections.emptyList();
        }
        if (featureValue instanceof String) {
            String value = featureValue.toString();
            if (value == null || value.length() == 0) {
                return Collections.emptyList();
            }
            if (NumericTypeUtil.isDigits(value)) {
                if (yearDigitsPattern.matcher(value).matches()) {
                    return Collections.singletonList(new Feature(featureName, NumericType.YEAR_DIGITS.toString()));
                }
                return Collections.singletonList(new Feature(featureName, NumericType.DIGITS.toString()));
            }
            if (NumericTypeUtil.containsDigits(value)) {
                if (alphanumericPattern.matcher(value).matches() && someLetters.matcher(value).find()) {
                    return Collections.singletonList(new Feature(featureName, NumericType.ALPHANUMERIC.toString()));
                }
                return Collections.singletonList(new Feature(featureName, NumericType.SOME_DIGITS.toString()));
            }
            if (romanNumeralPattern.matcher(value).matches()) {
                return Collections.singletonList(new Feature(featureName, NumericType.ROMAN_NUMERAL.toString()));
            }
        }
        return Collections.emptyList();
    }

    public static enum NumericType {
        DIGITS,
        YEAR_DIGITS,
        ALPHANUMERIC,
        SOME_DIGITS,
        ROMAN_NUMERAL;

    }
}

