/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.proliferate;

import java.util.Collections;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.proliferate.FeatureProliferator;

@Deprecated
public class CharacterNGramProliferator
extends FeatureProliferator {
    public static final int RIGHT_TO_LEFT = 0;
    public static final int LEFT_TO_RIGHT = 1;
    int orientation;
    int start;
    int end;
    int minimumValueLength;
    boolean lowerCase;

    public CharacterNGramProliferator(String featureName, int orientation, int start, int end, int minimumValueLength, boolean lowerCase) {
        super(Feature.createName("NGram", orientation == 0 ? "Right" : "Left", String.valueOf(start), String.valueOf(end), String.valueOf(minimumValueLength), lowerCase ? "lower" : null, featureName));
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of CharacterNGramProliferator.RIGHT_TO_LEFT or CharacterNGramProliferator.LEFT_TO_RIGHT ");
        }
        if (minimumValueLength < end) {
            throw new IllegalArgumentException("minimumValueLength must be greater than or equal to the parameter end.");
        }
        this.orientation = orientation;
        this.start = start;
        this.end = end;
        this.minimumValueLength = minimumValueLength;
        this.lowerCase = lowerCase;
    }

    public CharacterNGramProliferator(int orientation, int start, int end, int minimumValueLength, boolean lowerCase) {
        this(null, orientation, start, end, minimumValueLength, lowerCase);
    }

    public CharacterNGramProliferator(String featureName, int orientation, int start, int end) {
        this(featureName, orientation, start, end, end - start, false);
    }

    public CharacterNGramProliferator(int orientation, int start, int end) {
        this(null, orientation, start, end);
    }

    @Override
    public List<Feature> proliferate(Feature feature) {
        String featureName = Feature.createName(this.getFeatureName(), feature.getName());
        Object featureValue = feature.getValue();
        if (featureValue == null || !(featureValue instanceof String)) {
            return Collections.emptyList();
        }
        String value = featureValue.toString();
        if (value == null || value.length() < this.minimumValueLength) {
            return Collections.emptyList();
        }
        String ngram = this.orientation == 1 ? value.substring(this.start, this.end) : value.substring(value.length() - this.end, value.length() - this.start);
        if (this.lowerCase) {
            ngram = ngram.toLowerCase();
        }
        return Collections.singletonList(new Feature(featureName, ngram));
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public int getMinimumValueLength() {
        return this.minimumValueLength;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getStart() {
        return this.start;
    }
}

