/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.proliferate;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.proliferate.FeatureProliferator;
import org.cleartk.classifier.feature.util.NumericTypeUtil;

@Deprecated
public class NumericTypeProliferator
extends FeatureProliferator {
    public static final String DEFAULT_NAME = "NumericType";
    public static final String DIGITS = "DIGITS";
    public static final String YEAR_DIGITS = "YEAR_DIGITS";
    public static final String ALPHANUMERIC = "ALPHANUMERIC";
    public static final String SOME_DIGITS = "SOME_DIGITS";
    public static final String ROMAN_NUMERAL = "ROMAN_NUMERAL";
    static Pattern yearDigitsPattern = Pattern.compile("(?:1[0-9]{3,3})|(?:2[0|1][0-9]{2,2})");
    static Pattern alphanumericPattern = Pattern.compile("[a-zA-Z0-9-]+");
    static Pattern someLetters = Pattern.compile("[a-zA-Z]");
    static Pattern romanNumeralPattern = Pattern.compile("^M?M?M?(CM|CD|D?C?C?C?)(XC|XL|L?X?X?X?)(IX|IV|V?I?I?I?)$");

    public NumericTypeProliferator() {
        super(DEFAULT_NAME);
    }

    public NumericTypeProliferator(String featureName) {
        super(featureName);
    }

    @Override
    public List<Feature> proliferate(Feature feature) {
        String featureName = Feature.createName(this.getFeatureName(), feature.getName());
        Object featureValue = feature.getValue();
        if (featureValue == null) {
            return Collections.emptyList();
        }
        if (featureValue instanceof String) {
            String value = featureValue.toString();
            if (value == null || value.length() == 0) {
                return Collections.emptyList();
            }
            if (NumericTypeUtil.isDigits(value)) {
                if (yearDigitsPattern.matcher(value).matches()) {
                    return Collections.singletonList(new Feature(featureName, YEAR_DIGITS));
                }
                return Collections.singletonList(new Feature(featureName, DIGITS));
            }
            if (NumericTypeUtil.containsDigits(value)) {
                if (alphanumericPattern.matcher(value).matches() && someLetters.matcher(value).find()) {
                    return Collections.singletonList(new Feature(featureName, ALPHANUMERIC));
                }
                return Collections.singletonList(new Feature(featureName, SOME_DIGITS));
            }
            if (romanNumeralPattern.matcher(value).matches()) {
                return Collections.singletonList(new Feature(featureName, ROMAN_NUMERAL));
            }
        }
        return Collections.emptyList();
    }
}

