/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.selection;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.transform.TrainableExtractor_ImplBase;
import org.cleartk.classifier.feature.transform.TransformableFeature;

public abstract class FeatureSelectionExtractor<OUTCOME_T>
extends TrainableExtractor_ImplBase<OUTCOME_T>
implements Predicate<Feature> {
    public FeatureSelectionExtractor(String name) {
        super(name);
    }

    @Override
    public Instance<OUTCOME_T> transform(Instance<OUTCOME_T> instance) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Feature feature : instance.getFeatures()) {
            if (this.isTransformable(feature)) {
                features.addAll(Collections2.filter(((TransformableFeature)feature).getFeatures(), (Predicate)this));
                continue;
            }
            features.add(feature);
        }
        return new Instance<OUTCOME_T>(instance.getOutcome(), features);
    }
}

