/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.transform.InstanceStream;

public class InstanceDataWriter<OUTCOME_T>
implements DataWriter<OUTCOME_T> {
    ObjectOutputStream objout;
    public static String INSTANCES_OUTPUT_FILENAME = "training-data.instances";

    public InstanceDataWriter(File outputDirectory) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        File outputFile = new File(outputDirectory, INSTANCES_OUTPUT_FILENAME);
        this.objout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
    }

    @Override
    public void write(Instance<OUTCOME_T> instance) throws CleartkProcessingException {
        try {
            this.objout.writeObject(instance);
        }
        catch (IOException e) {
            throw new CleartkProcessingException("", "Unable to write Instance", e);
        }
    }

    @Override
    public void finish() throws CleartkProcessingException {
        try {
            InstanceStream.Terminator terminator = new InstanceStream.Terminator();
            this.objout.writeObject(terminator);
            this.objout.close();
        }
        catch (IOException e) {
            throw new CleartkProcessingException("", "Unable to write terminal instance", e);
        }
    }
}

