/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.transform.extractor;

import java.util.Map;
import org.cleartk.classifier.feature.transform.extractor.CosineSimilarity;
import org.cleartk.classifier.feature.transform.extractor.SimilarityFunction;

public class FixedCosineSimilarity
implements SimilarityFunction {
    protected Map<String, Double> fixedVector;
    protected double fixedMagnitude;

    public FixedCosineSimilarity(Map<String, Double> fixedVector) {
        this.fixedVector = fixedVector;
        this.fixedMagnitude = CosineSimilarity.magnitude(fixedVector);
    }

    public double distance(Map<String, Double> vector) {
        double magnitude = CosineSimilarity.magnitude(vector);
        return magnitude == 0.0 || this.fixedMagnitude == 0.0 ? 0.0 : CosineSimilarity.dotProduct(vector, this.fixedVector) / (magnitude * this.fixedMagnitude);
    }

    @Override
    public double distance(Map<String, Double> vector1, Map<String, Double> vector2) {
        return this.distance(vector1);
    }
}

