/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.util;

import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;

public class InstanceFactory {
    public static <T> Instance<T> createInstance(T outcome, Object ... featureData) {
        if (featureData.length % 2 != 0) {
            throw new IllegalArgumentException("feature data must consist of an even number of elements corresponding to name/value pairs used to create features. ");
        }
        Instance<T> instance = new Instance<T>(outcome);
        for (int i = 0; i < featureData.length; i += 2) {
            instance.add(new Feature(featureData[i].toString(), featureData[i + 1]));
        }
        return instance;
    }

    public static <T> Instance<T> createInstance(T outcome, String featureData) {
        Instance<T> instance = new Instance<T>(outcome);
        String[] columns = featureData.split(" ");
        for (int i = 0; i < columns.length; ++i) {
            Feature feature = new Feature();
            feature.setName(columns[i]);
            instance.add(feature);
        }
        return instance;
    }
}

