/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.util.featurevector;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cleartk.classifier.util.featurevector.InvalidFeatureVectorValueException;

public abstract class FeatureVector
implements Iterable<Entry> {
    public void add(FeatureVector other) throws InvalidFeatureVectorValueException {
        for (Entry entry : other) {
            this.set(entry.index, this.get(entry.index) + entry.value);
        }
    }

    public void multiply(double factor) throws InvalidFeatureVectorValueException {
        for (Entry entry : this) {
            this.set(entry.index, this.get(entry.index) * factor);
        }
    }

    public double l2Norm() {
        double l = 0.0;
        for (Entry entry : this) {
            l += entry.value * entry.value;
        }
        return Math.sqrt(l);
    }

    public boolean equals(Object o) {
        FeatureVector other;
        try {
            other = (FeatureVector)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        Iterator<Entry> thisIt = this.iterator();
        Iterator<Entry> otherIt = other.iterator();
        while (thisIt.hasNext() || otherIt.hasNext()) {
            Entry otherEntry;
            Entry thisEntry;
            try {
                thisEntry = thisIt.next();
                otherEntry = otherIt.next();
            }
            catch (NoSuchElementException e) {
                return false;
            }
            if (thisEntry.equals(otherEntry)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1451;
        for (Entry e : this) {
            result = 757 * result + e.hashCode();
        }
        return result;
    }

    public abstract void set(int var1, double var2) throws InvalidFeatureVectorValueException;

    public abstract double get(int var1);

    @Override
    public abstract Iterator<Entry> iterator();

    public double innerProduct(FeatureVector other) {
        double result = 0.0;
        for (Entry entry : other) {
            result += this.get(entry.index) * entry.value;
        }
        return result;
    }

    public static class Entry {
        public final int index;
        public final double value;

        public Entry(int index, double value) {
            this.index = index;
            this.value = value;
        }

        public boolean equals(Object o) {
            Entry other;
            try {
                other = (Entry)o;
            }
            catch (ClassCastException e) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            return this.value == other.value;
        }

        public int hashCode() {
            int result = 83;
            result = 47 * result + this.index;
            result = 47 * result + new Double(this.value).hashCode();
            return result;
        }
    }
}

