/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.util.tfidf;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cleartk.classifier.feature.Counts;

@Deprecated
public class IDFMap
implements Serializable {
    private static final long serialVersionUID = 8053199003361771143L;
    private int totalDocumentCount = 0;
    private Map<String, Integer> documentCounts = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDFMap read(File file) throws IOException {
        IDFMap idfMap = new IDFMap();
        try {
            ResultSet rs;
            Connection connection = IDFMap.openDB(file);
            PreparedStatement stat = connection.prepareStatement("select value from globals where name = ?");
            try {
                stat.setString(1, "totalDocumentCount");
                rs = stat.executeQuery();
                try {
                    rs.next();
                    idfMap.totalDocumentCount = rs.getInt(1);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stat.close();
            }
            stat = connection.prepareStatement("select key, count from documentcounts ");
            try {
                rs = stat.executeQuery();
                try {
                    while (rs.next()) {
                        String key = rs.getString("key");
                        int count = rs.getInt("count");
                        idfMap.documentCounts.put(key, count);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stat.close();
            }
            connection.close();
            return idfMap;
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    public void consume(Counts counts) {
        ++this.totalDocumentCount;
        for (Object object : counts.getValues()) {
            if (counts.getCount(object) == 0) continue;
            String valueString = object.toString();
            if (this.documentCounts.containsKey(valueString)) {
                this.documentCounts.put(valueString, this.documentCounts.get(valueString) + 1);
                continue;
            }
            this.documentCounts.put(valueString, 1);
        }
    }

    public Double getIDF(Object key) {
        String keyString = key.toString();
        Double documentCount = this.documentCounts.containsKey(keyString) ? (double)this.documentCounts.get(keyString).intValue() : 0.0;
        return Math.log((double)(this.totalDocumentCount + 1) / (documentCount + 1.0));
    }

    public int getTotalDocumentCount() {
        return this.totalDocumentCount;
    }

    public int getDocumentCount(Object key) {
        String keyString = key.toString();
        return this.documentCounts.containsKey(keyString) ? this.documentCounts.get(keyString) : 0;
    }

    public Iterator<?> getValues() {
        return this.documentCounts.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        try {
            File tempFile = new File(file.toString() + "_temp");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            Connection connection = IDFMap.createDB(tempFile);
            PreparedStatement stat = connection.prepareStatement("insert into globals (name, value) values (?, ?)");
            try {
                stat.setString(1, "totalDocumentCount");
                stat.setInt(2, this.totalDocumentCount);
                stat.execute();
            }
            finally {
                stat.close();
            }
            for (String key : this.documentCounts.keySet()) {
                stat = connection.prepareStatement("insert into documentcounts (key, count) values (?, ?)");
                try {
                    stat.setString(1, key);
                    stat.setInt(2, this.documentCounts.get(key));
                    stat.execute();
                }
                finally {
                    stat.close();
                }
            }
            connection.commit();
            connection.close();
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection createDB(File file) throws SQLException {
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:" + file.toString());
            connection.setAutoCommit(false);
            PreparedStatement stat = connection.prepareStatement("create table documentcounts (key text, count integer)");
            try {
                stat.execute();
            }
            finally {
                stat.close();
            }
            stat = connection.prepareStatement("create table globals (name text, value)");
            try {
                stat.execute();
            }
            finally {
                stat.close();
            }
            connection.commit();
            return connection;
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException("org.sqlite.JDBC", e);
        }
    }

    private static Connection openDB(File file) throws SQLException {
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:" + file.toString());
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException("org.sqlite.JDBC", e);
        }
    }
}

