/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.util.tfidf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.Counts;
import org.cleartk.classifier.feature.FeatureCollection;
import org.cleartk.classifier.util.tfidf.IDFMap;

@Deprecated
public class IDFMapWriter<OUTCOME_TYPE>
implements DataWriter<OUTCOME_TYPE> {
    private Map<String, IDFMap> idfMaps = new HashMap<String, IDFMap>();
    private File outputDirectory;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public IDFMapWriter(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private File getIDFMapFile(String identifier) {
        if ((identifier = identifier == null ? "default" : identifier.toLowerCase()).equals("default")) {
            return new File(this.outputDirectory, "idfmap");
        }
        return new File(this.outputDirectory, "idfmap_" + identifier);
    }

    private IDFMap getIDFMap(String identifier) throws IOException {
        IDFMap idfMap;
        if (this.idfMaps.containsKey(identifier = identifier == null ? "default" : identifier.toLowerCase())) {
            return this.idfMaps.get(identifier);
        }
        File idfMapFile = this.getIDFMapFile(identifier);
        if (idfMapFile.exists()) {
            this.logger.info(String.format("load existing idf map \"%s\" from %s", identifier, idfMapFile.toString()));
            idfMap = IDFMap.read(idfMapFile);
        } else {
            this.logger.info(String.format("initialize new idf map \"%s\"", identifier));
            idfMap = new IDFMap();
        }
        this.idfMaps.put(identifier, idfMap);
        return idfMap;
    }

    public boolean isTraining() {
        return false;
    }

    @Override
    public void write(Instance<OUTCOME_TYPE> instance) throws CleartkProcessingException {
        this.consumeFeatures(instance.getFeatures());
    }

    private void consumeFeatures(Collection<Feature> features) throws CleartkProcessingException {
        for (Feature feature : features) {
            if (feature.getValue() instanceof Counts) {
                IDFMap idfMap;
                Counts counts = (Counts)feature.getValue();
                try {
                    idfMap = this.getIDFMap(counts.getIdentifier());
                }
                catch (IOException e) {
                    throw new CleartkProcessingException(e);
                }
                idfMap.consume(counts);
                continue;
            }
            if (!(feature.getValue() instanceof FeatureCollection)) continue;
            FeatureCollection fc = (FeatureCollection)feature.getValue();
            this.consumeFeatures(fc.getFeatures());
        }
    }

    @Override
    public void finish() throws CleartkProcessingException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (String identifier : this.idfMaps.keySet()) {
            IDFMap idfMap = this.idfMaps.get(identifier);
            File idfMapFile = this.getIDFMapFile(identifier);
            try {
                this.logger.info(String.format("write idf map \"%s\" to %s.  size=" + idfMap.getTotalDocumentCount(), identifier, idfMapFile.toString()));
                idfMap.write(idfMapFile);
            }
            catch (IOException e1) {
                exceptions.add(e1);
            }
        }
        if (exceptions.size() > 0) {
            if (exceptions.size() == 1) {
                throw new CleartkProcessingException((Throwable)exceptions.get(0));
            }
            throw CleartkProcessingException.multipleExceptions(exceptions);
        }
    }
}

