/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.viterbi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.viterbi.OutcomeFeatureExtractor;
import org.cleartk.util.CleartkInitializationException;
import org.uimafit.component.initialize.ConfigurationParameterInitializer;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;

public class DefaultOutcomeFeatureExtractor
implements OutcomeFeatureExtractor {
    private static final long serialVersionUID = 7476684786572310025L;
    public static final String PARAM_MOST_RECENT_OUTCOME = ConfigurationParameterFactory.createConfigurationParameterName(DefaultOutcomeFeatureExtractor.class, (String)"mostRecentOutcome");
    @ConfigurationParameter(description="indicates the position of the first (most recent) outcome to include. For example, the default value of 1 means that if the outcomes produced so far by the classifier were [A, B, C, D], then the first outcome to be used as a feature would be D since it is the most recent.", defaultValue={"1"})
    private int mostRecentOutcome = 1;
    public static final String PARAM_LEAST_RECENT_OUTCOME = ConfigurationParameterFactory.createConfigurationParameterName(DefaultOutcomeFeatureExtractor.class, (String)"leastRecentOutcome");
    @ConfigurationParameter(description="indicates the position of the last (least recent) outcome to include. For example, the default value of 3 means that if the outcomes produced so far by the classifier were [A, B, C, D], then the last outcome to be used as a feature would be B since and is considered the least recent.", defaultValue={"3"})
    private int leastRecentOutcome = 3;
    public static final String PARAM_USE_BIGRAM = ConfigurationParameterFactory.createConfigurationParameterName(DefaultOutcomeFeatureExtractor.class, (String)"useBigram");
    @ConfigurationParameter(description="when true indicates that bigrams of outcomes should be included as features", defaultValue={"true"})
    private boolean useBigram = true;
    public static final String PARAM_USE_TRIGRAM = ConfigurationParameterFactory.createConfigurationParameterName(DefaultOutcomeFeatureExtractor.class, (String)"useTrigram");
    @ConfigurationParameter(defaultValue={"true"}, description="indicates that trigrams of outcomes should be included as features")
    private boolean useTrigram = true;
    public static final String PARAM_USE4GRAM = ConfigurationParameterFactory.createConfigurationParameterName(DefaultOutcomeFeatureExtractor.class, (String)"use4gram");
    @ConfigurationParameter(defaultValue={"false"}, description="indicates that 4-grams of outcomes should be included as features")
    private boolean use4gram = false;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        if (this.mostRecentOutcome < 1) {
            throw CleartkInitializationException.parameterLessThan((String)PARAM_MOST_RECENT_OUTCOME, (Object)1, (Object)this.mostRecentOutcome);
        }
        if (this.leastRecentOutcome < this.mostRecentOutcome) {
            throw CleartkInitializationException.parameterLessThan((String)PARAM_LEAST_RECENT_OUTCOME, (Object)this.mostRecentOutcome, (Object)this.leastRecentOutcome);
        }
    }

    @Override
    public List<Feature> extractFeatures(List<Object> previousOutcomes) {
        int size;
        Feature feature;
        if (previousOutcomes == null || previousOutcomes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = this.mostRecentOutcome; i <= this.leastRecentOutcome; ++i) {
            int index = previousOutcomes.size() - i;
            if (index < 0) continue;
            feature = new Feature("PreviousOutcome_L" + i, previousOutcomes.get(index));
            features.add(feature);
        }
        if (this.useBigram && previousOutcomes.size() >= 2) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).toString() + "_" + previousOutcomes.get(size - 2);
            feature = new Feature("PreviousOutcomes_L1_2gram_L2R", featureValue);
            features.add(feature);
        }
        if (this.useTrigram && previousOutcomes.size() >= 3) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).toString() + "_" + previousOutcomes.get(size - 2) + "_" + previousOutcomes.get(size - 3);
            feature = new Feature("PreviousOutcomes_L1_3gram_L2R", featureValue);
            features.add(feature);
        }
        if (this.use4gram && previousOutcomes.size() >= 4) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).toString() + "_" + previousOutcomes.get(size - 2) + "_" + previousOutcomes.get(size - 3) + "_" + previousOutcomes.get(size - 4);
            feature = new Feature("PreviousOutcomes_L1_4gram_L2R", featureValue);
            features.add(feature);
        }
        return features;
    }
}

