/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.viterbi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.Classifier;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.ScoredOutcome;
import org.cleartk.classifier.SequenceClassifier;
import org.cleartk.classifier.viterbi.OutcomeFeatureExtractor;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;
import org.uimafit.component.initialize.ConfigurationParameterInitializer;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.Initializable;

public class ViterbiClassifier<OUTCOME_TYPE>
implements SequenceClassifier<OUTCOME_TYPE>,
Initializable,
ReflectionUtil.TypeArgumentDelegator {
    protected Classifier<OUTCOME_TYPE> delegatedClassifier;
    protected OutcomeFeatureExtractor[] outcomeFeatureExtractors;
    public static final String PARAM_STACK_SIZE = ConfigurationParameterFactory.createConfigurationParameterName(ViterbiClassifier.class, (String)"stackSize");
    @ConfigurationParameter(description="specifies the maximum number of candidate paths to keep track of. In general, this number should be higher than the number of possible classifications at any given point in the sequence. This guarantees that highest-possible scoring sequence will be returned. If, however, the number of possible classifications is quite high and/or you are concerned about throughput performance, then you may want to reduce the number of candidate paths to maintain.  If Classifier.score is not implemented for the given delegated classifier, then the value of this parameter must be 1. ", defaultValue={"1"})
    protected int stackSize;
    public static final String PARAM_ADD_SCORES = ConfigurationParameterFactory.createConfigurationParameterName(ViterbiClassifier.class, (String)"addScores");
    @ConfigurationParameter(description="specifies whether the scores of candidate sequence classifications should be calculated by summing classfication scores for each member of the sequence or by multiplying them. A value of true means that the scores will be summed. A value of false means that the scores will be multiplied. ", defaultValue={"false"})
    protected boolean addScores = false;

    public ViterbiClassifier(Classifier<OUTCOME_TYPE> delegatedClassifier, OutcomeFeatureExtractor[] outcomeFeatureExtractors) {
        this.delegatedClassifier = delegatedClassifier;
        this.outcomeFeatureExtractors = outcomeFeatureExtractors;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        if (this.stackSize < 1) {
            throw CleartkInitializationException.parameterLessThan((String)PARAM_STACK_SIZE, (Object)1, (Object)this.stackSize);
        }
    }

    @Override
    public List<OUTCOME_TYPE> classify(List<List<Feature>> features) throws CleartkProcessingException {
        if (this.stackSize == 1) {
            ArrayList<Object> outcomes = new ArrayList<Object>();
            ArrayList<OUTCOME_TYPE> returnValues = new ArrayList<OUTCOME_TYPE>();
            for (List<Feature> instanceFeatures : features) {
                for (OutcomeFeatureExtractor outcomeFeatureExtractor : this.outcomeFeatureExtractors) {
                    instanceFeatures.addAll(outcomeFeatureExtractor.extractFeatures(outcomes));
                }
                OUTCOME_TYPE outcome = this.delegatedClassifier.classify(instanceFeatures);
                outcomes.add(outcome);
                returnValues.add(outcome);
            }
            return returnValues;
        }
        try {
            return this.viterbi(features);
        }
        catch (UnsupportedOperationException uoe) {
            throw CleartkProcessingException.unsupportedOperationSetParameter(this.delegatedClassifier, "score", PARAM_STACK_SIZE, 1);
        }
    }

    public List<OUTCOME_TYPE> viterbi(List<List<Feature>> features) throws CleartkProcessingException {
        ArrayList nbestSequences = new ArrayList();
        if (features == null || features.size() == 0) {
            return Collections.emptyList();
        }
        List<ScoredOutcome<OUTCOME_TYPE>> scoredOutcomes = this.delegatedClassifier.score(features.get(0), this.stackSize);
        for (ScoredOutcome<OUTCOME_TYPE> scoredOutcome : scoredOutcomes) {
            double score = scoredOutcome.getScore();
            ArrayList<OUTCOME_TYPE> sequence = new ArrayList<OUTCOME_TYPE>();
            sequence.add(scoredOutcome.getOutcome());
            nbestSequences.add(new ScoredOutcome(sequence, score));
        }
        HashMap<OUTCOME_TYPE, Double> l = new HashMap<OUTCOME_TYPE, Double>();
        HashMap m = new HashMap();
        for (int i = 1; i < features.size(); ++i) {
            List<Feature> instanceFeatures = features.get(i);
            l.clear();
            m.clear();
            for (ScoredOutcome scoredOutcome : nbestSequences) {
                int outcomeFeaturesCount = 0;
                ArrayList<Object> previousOutcomes = new ArrayList<Object>((Collection)scoredOutcome.getOutcome());
                for (OutcomeFeatureExtractor outcomeFeatureExtractor : this.outcomeFeatureExtractors) {
                    List<Feature> outcomeFeatures = outcomeFeatureExtractor.extractFeatures(previousOutcomes);
                    instanceFeatures.addAll(outcomeFeatures);
                    outcomeFeaturesCount += outcomeFeatures.size();
                }
                scoredOutcomes = this.delegatedClassifier.score(instanceFeatures, this.stackSize);
                instanceFeatures = instanceFeatures.subList(0, instanceFeatures.size() - outcomeFeaturesCount);
                for (ScoredOutcome<OUTCOME_TYPE> scoredOutcome2 : scoredOutcomes) {
                    if (!l.containsKey(scoredOutcome2.getOutcome())) {
                        double score = scoredOutcome.getScore();
                        score = this.addScores ? (score += scoredOutcome2.getScore()) : (score *= scoredOutcome2.getScore());
                        l.put(scoredOutcome2.getOutcome(), score);
                        m.put(scoredOutcome2.getOutcome(), new ArrayList((Collection)scoredOutcome.getOutcome()));
                        continue;
                    }
                    double newScore = scoredOutcome.getScore();
                    newScore = this.addScores ? (newScore += scoredOutcome2.getScore()) : (newScore *= scoredOutcome2.getScore());
                    double bestScore = (Double)l.get(scoredOutcome2.getOutcome());
                    if (!(newScore > bestScore)) continue;
                    l.put(scoredOutcome2.getOutcome(), newScore);
                    m.put(scoredOutcome2.getOutcome(), new ArrayList((Collection)scoredOutcome.getOutcome()));
                }
            }
            nbestSequences.clear();
            for (Object object : l.keySet()) {
                List outcomeSequence = (List)m.get(object);
                outcomeSequence.add(object);
                double score = (Double)l.get(object);
                ScoredOutcome<List> returnValue = new ScoredOutcome<List>(outcomeSequence, score);
                nbestSequences.add(returnValue);
            }
            Collections.sort(nbestSequences);
        }
        Collections.sort(nbestSequences);
        if (nbestSequences.size() > 0) {
            return (List)((ScoredOutcome)nbestSequences.get(0)).getOutcome();
        }
        return null;
    }

    @Override
    public List<ScoredOutcome<List<OUTCOME_TYPE>>> score(List<List<Feature>> features, int maxResults) throws CleartkProcessingException {
        return null;
    }

    public Map<String, Type> getTypeArguments(Class<?> genericType) {
        if (genericType.equals(SequenceClassifier.class)) {
            genericType = Classifier.class;
        }
        return ReflectionUtil.getTypeArguments(genericType, this.delegatedClassifier);
    }
}

