/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.syntax.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.Span;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.syntax.opennlp.parser.CasPosTagger;
import org.cleartk.syntax.opennlp.parser.DefaultOutputTypesHelper;
import org.cleartk.syntax.opennlp.parser.InputTypesHelper;
import org.cleartk.syntax.opennlp.parser.Parser;
import org.cleartk.syntax.opennlp.parser.ParserWrapper_ImplBase;
import org.cleartk.util.IOUtil;
import org.cleartk.util.ParamUtil;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;

public class ParserAnnotator<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation, TOP_NODE_TYPE extends Annotation>
extends ParserWrapper_ImplBase<TOKEN_TYPE, SENTENCE_TYPE, Parse, TOP_NODE_TYPE> {
    public static final String DEFAULT_PARSER_MODEL_PATH = "/models/en-parser-chunking.bin";
    public static final int DEFAULT_BEAM_SIZE = 20;
    public static final float DEFAULT_ADVANCE_PERCENTAGE = 0.95f;
    public static final String PARAM_PARSER_MODEL_PATH = ConfigurationParameterFactory.createConfigurationParameterName(ParserAnnotator.class, (String)"parserModelPath");
    @ConfigurationParameter(defaultValue={"/models/en-parser-chunking.bin"}, description="provides the path of the OpenNLP parser model build file, e.g. /models/en-parser-chunking.bin.  See javadoc for opennlp.tools.parser.chunking.Parser.")
    private String parserModelPath;
    public static final String PARAM_BEAM_SIZE = ConfigurationParameterFactory.createConfigurationParameterName(ParserAnnotator.class, (String)"beamSize");
    @ConfigurationParameter(defaultValue={"20"}, description="indicates the beam size that should be used in the parser's search.  See javadoc for opennlp.tools.parser.chunking.Parser.")
    private int beamSize;
    public static final String PARAM_ADVANCE_PERCENTAGE = ConfigurationParameterFactory.createConfigurationParameterName(ParserAnnotator.class, (String)"advancePercentage");
    @ConfigurationParameter(defaultValue={"0.95"}, description="indicates \"the amount of probability mass required of advanced outcomes\".  See javadoc for opennlp.tools.parser.chunking.Parser.")
    private float advancePercentage;
    public static final String PARAM_USE_TAGS_FROM_CAS = ConfigurationParameterFactory.createConfigurationParameterName(ParserAnnotator.class, (String)"useTagsFromCas");
    @ConfigurationParameter(defaultValue={"false"}, description="determines whether or not part-of-speech tags that are already in the CAS will be used or not.")
    private boolean useTagsFromCas;
    protected Parser parser;
    protected CasPosTagger<TOKEN_TYPE, SENTENCE_TYPE> casTagger;

    @Override
    public void initialize(UimaContext ctx) throws ResourceInitializationException {
        super.initialize(ctx);
        this.inputTypesHelper = (InputTypesHelper)InitializableFactory.create((UimaContext)ctx, (String)this.inputTypesHelperClassName, InputTypesHelper.class);
        try {
            InputStream modelInputStream = IOUtil.getInputStream(ParserAnnotator.class, (String)this.parserModelPath);
            ParserModel parserModel = new ParserModel(modelInputStream);
            if (this.useTagsFromCas) {
                this.casTagger = new CasPosTagger(this.inputTypesHelper);
                this.parser = new Parser(parserModel, this.beamSize, this.advancePercentage, this.casTagger);
            } else {
                this.parser = new Parser(parserModel, this.beamSize, this.advancePercentage);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String text = jCas.getDocumentText();
        List sentenceList = this.inputTypesHelper.getSentences(jCas);
        for (Annotation sentence : sentenceList) {
            Parse parse = new Parse(text, new Span(sentence.getBegin(), sentence.getEnd()), "INC", 1.0, null);
            List tokenList = this.inputTypesHelper.getTokens(jCas, sentence);
            for (Annotation token : tokenList) {
                parse.insert(new Parse(text, new Span(token.getBegin(), token.getEnd()), "TK", 0.0, 0));
            }
            if (this.useTagsFromCas) {
                this.casTagger.setTokens(tokenList);
            }
            if ((parse = this.parser.parse(parse)).getType() == "TOP") {
                this.outputTypesHelper.addParse(jCas, parse, sentence, tokenList);
            }
            if (this.useTagsFromCas) continue;
            this.setPOSTags(parse, tokenList.iterator(), jCas);
        }
    }

    protected void setPOSTags(Parse p, Iterator<TOKEN_TYPE> tokenIterator, JCas view) {
        if (p.isPosTag()) {
            Annotation t = (Annotation)tokenIterator.next();
            this.inputTypesHelper.setPosTag(t, p.getType());
        } else {
            for (Parse child : p.getChildren()) {
                this.setPOSTags(child, tokenIterator, view);
            }
        }
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(ParserAnnotator.class, (Object[])new Object[]{PARAM_PARSER_MODEL_PATH, ParamUtil.getParameterValue((String)PARAM_PARSER_MODEL_PATH, (String)DEFAULT_PARSER_MODEL_PATH), PARAM_OUTPUT_TYPES_HELPER_CLASS_NAME, DefaultOutputTypesHelper.class.getName()});
    }
}

