/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.syntax.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.IOUtil;
import org.cleartk.util.ParamUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.cleartk.token.type.Sentence", "org.cleartk.token.type.Token"})
public class PosTaggerAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_POSTAG_MODEL_FILE = ConfigurationParameterFactory.createConfigurationParameterName(PosTaggerAnnotator.class, (String)"postagModelFile");
    @ConfigurationParameter(mandatory=true, description="provides the path of the OpenNLP part-of-speech tagger model file, e.g.  resources/models/OpenNLP.POSTags.English.bin.gz.  See javadoc for opennlp.maxent.io.SuffixSensitiveGISModelReader.")
    private String postagModelFile;
    protected POSTagger posTagger;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(PosTaggerAnnotator.class, (Object[])new Object[]{PARAM_POSTAG_MODEL_FILE, ParamUtil.getParameterValue((String)PARAM_POSTAG_MODEL_FILE, (String)"/models/en-pos-maxent.bin")});
    }

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            InputStream modelInputStream = IOUtil.getInputStream(PosTaggerAnnotator.class, (String)this.postagModelFile);
            POSModel posModel = new POSModel(modelInputStream);
            this.posTagger = new POSTaggerME(posModel);
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            String[] tokenTexts = new String[tokens.size()];
            for (int i = 0; i < tokenTexts.length; ++i) {
                tokenTexts[i] = ((Token)tokens.get(i)).getCoveredText();
            }
            String[] tags = this.posTagger.tag(tokenTexts);
            for (int i = 0; i < tags.length; ++i) {
                ((Token)tokens.get(i)).setPos(tags[i]);
            }
        }
    }
}

