/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.syntax.opennlp.parser;

import java.util.List;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.util.Sequence;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.syntax.opennlp.parser.InputTypesHelper;

public class CasPosTagger<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation>
implements POSTagger {
    private List<TOKEN_TYPE> tokens;
    InputTypesHelper<TOKEN_TYPE, SENTENCE_TYPE> inputTypesHelper;

    public CasPosTagger(InputTypesHelper<TOKEN_TYPE, SENTENCE_TYPE> inputTypesHelper) {
        this.inputTypesHelper = inputTypesHelper;
    }

    public void setTokens(List<TOKEN_TYPE> tokens) {
        this.tokens = tokens;
    }

    public Sequence[] topKSequences(List<String> sentence) {
        return this.topKSequences(sentence.toArray(new String[sentence.size()]));
    }

    public Sequence[] topKSequences(String[] sentence) {
        Sequence[] s = new Sequence[]{new Sequence()};
        for (Annotation token : this.tokens) {
            String pos = this.inputTypesHelper.getPosTag(token);
            if (pos == null) {
                throw new RuntimeException("no part of speech for token: " + token.getCoveredText());
            }
            s[0].add(pos, 1.0);
        }
        return s;
    }

    public List<String> tag(List<String> sentence) {
        throw new UnsupportedOperationException();
    }

    public String[] tag(String[] sentence) {
        throw new UnsupportedOperationException();
    }

    public String tag(String sentence) {
        throw new UnsupportedOperationException();
    }
}

