/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.syntax.opennlp.parser;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.parser.Parse;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.syntax.constituent.type.TerminalTreebankNode;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.opennlp.parser.OutputTypesHelper;
import org.uimafit.util.FSCollectionFactory;

public class DefaultOutputTypesHelper<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation>
implements OutputTypesHelper<TOKEN_TYPE, SENTENCE_TYPE, Parse, TreebankNode> {
    @Override
    public TreebankNode addParse(JCas jCas, Parse parse, SENTENCE_TYPE sentence, List<TOKEN_TYPE> tokens) {
        TopTreebankNode node = new TopTreebankNode(jCas);
        this.setAttributes((TreebankNode)node, parse, null, jCas);
        node.addToIndexes();
        StringBuffer sb = new StringBuffer();
        parse.show(sb);
        node.setTreebankParse(sb.toString());
        List<TreebankNode> terminals = this.getTerminals((TreebankNode)node);
        node.setTerminals(new FSArray(jCas, terminals.size()));
        FSCollectionFactory.fillArrayFS((ArrayFS)node.getTerminals(), terminals);
        return node;
    }

    private void setAttributes(TreebankNode node, Parse parse, TreebankNode parent, JCas jCas) {
        node.setParent(parent);
        node.setNodeType(parse.getType());
        node.setBegin(parse.getSpan().getStart());
        node.setEnd(parse.getSpan().getEnd());
        if (this.isLeaf(parse)) {
            node.setLeaf(true);
            node.setNodeValue(parse.getChildren()[0].toString());
            node.setChildren(new FSArray(jCas, 0));
        } else {
            node.setLeaf(false);
            node.setNodeValue(null);
            ArrayList<TerminalTreebankNode> childNodes = new ArrayList<TerminalTreebankNode>();
            for (Parse childParse : parse.getChildren()) {
                TerminalTreebankNode childNode = this.isLeaf(childParse) ? new TerminalTreebankNode(jCas) : new TreebankNode(jCas);
                this.setAttributes((TreebankNode)childNode, childParse, node, jCas);
                childNode.addToIndexes();
                childNodes.add(childNode);
            }
            node.setChildren(new FSArray(jCas, childNodes.size()));
            FSCollectionFactory.fillArrayFS((ArrayFS)node.getChildren(), childNodes);
        }
    }

    protected List<TreebankNode> getTerminals(TreebankNode node) {
        ArrayList<TreebankNode> tList = new ArrayList<TreebankNode>();
        int nChildren = node.getChildren().size();
        if (nChildren == 0) {
            tList.add(node);
        }
        for (int i = 0; i < nChildren; ++i) {
            tList.addAll(this.getTerminals(node.getChildren(i)));
        }
        return tList;
    }

    private boolean isLeaf(Parse parse) {
        Parse[] childParses = parse.getChildren();
        return childParses.length == 1 && childParses[0].getType() == "TK";
    }
}

