/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.pos;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkSequenceAnnotator;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.token.pos.POSFeatureExtractor;
import org.cleartk.util.ReflectionUtil;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;
import org.uimafit.util.JCasUtil;

public abstract class POSAnnotator<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation>
extends CleartkSequenceAnnotator<String> {
    public static final String PARAM_FEATURE_EXTRACTOR_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(POSAnnotator.class, (String)"featureExtractorClassName");
    @ConfigurationParameter(mandatory=true, description="provides the full name of the class that will be used to extract features", defaultValue={"org.cleartk.token.pos.impl.DefaultFeatureExtractor"})
    private String featureExtractorClassName;
    protected POSFeatureExtractor<TOKEN_TYPE, SENTENCE_TYPE> featureExtractor;
    private Class<? extends TOP> tokenClass;
    private Class<? extends TOP> sentenceClass;
    protected boolean typesInitialized = false;
    protected Type tokenType;
    protected Type sentenceType;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.tokenClass = (Class)ReflectionUtil.uncheckedCast((Object)ReflectionUtil.getTypeArgument(POSAnnotator.class, (String)"TOKEN_TYPE", (Object)((Object)this)));
        this.sentenceClass = (Class)ReflectionUtil.uncheckedCast((Object)ReflectionUtil.getTypeArgument(POSAnnotator.class, (String)"SENTENCE_TYPE", (Object)((Object)this)));
        POSFeatureExtractor untypedExtractor = (POSFeatureExtractor)InitializableFactory.create((UimaContext)context, (String)this.featureExtractorClassName, POSFeatureExtractor.class);
        ReflectionUtil.checkTypeParameterIsAssignable(POSFeatureExtractor.class, (String)"TOKEN_TYPE", (Object)untypedExtractor, POSAnnotator.class, (String)"TOKEN_TYPE", (Object)((Object)this));
        ReflectionUtil.checkTypeParameterIsAssignable(POSFeatureExtractor.class, (String)"SENTENCE_TYPE", (Object)untypedExtractor, POSAnnotator.class, (String)"SENTENCE_TYPE", (Object)((Object)this));
        this.featureExtractor = (POSFeatureExtractor)ReflectionUtil.uncheckedCast((Object)untypedExtractor);
    }

    protected void initializeTypes(JCas jCas) throws AnalysisEngineProcessException {
        try {
            this.tokenType = JCasUtil.getType((JCas)jCas, this.tokenClass);
            this.sentenceType = JCasUtil.getType((JCas)jCas, this.sentenceClass);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        this.typesInitialized = true;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (!this.typesInitialized) {
            this.initializeTypes(jCas);
        }
        for (Annotation sentence : jCas.getAnnotationIndex(this.sentenceType)) {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            FSIterator tokens = jCas.getAnnotationIndex(this.tokenType).subiterator((AnnotationFS)sentence);
            while (tokens.hasNext()) {
                Annotation token = (Annotation)tokens.next();
                List<Feature> features = this.featureExtractor.extractFeatures(jCas, token, sentence);
                Instance instance = new Instance();
                instance.addAll(features);
                instance.setOutcome((Object)this.getTag(jCas, token));
                instances.add(instance);
            }
            if (this.isTraining()) {
                this.dataWriter.write(instances);
                continue;
            }
            List tags = this.classify(instances);
            tokens.moveToFirst();
            int i = 0;
            while (tokens.hasNext()) {
                Annotation token = (Annotation)tokens.next();
                this.setTag(jCas, token, (String)tags.get(i));
                ++i;
            }
        }
    }

    public abstract void setTag(JCas var1, TOKEN_TYPE var2, String var3);

    public abstract String getTag(JCas var1, TOKEN_TYPE var2);

    public void setFeatureExtractorClassName(String featureExtractorClassName) {
        this.featureExtractorClassName = featureExtractorClassName;
    }
}

