/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.pos.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.function.CapitalTypeFeatureFunction;
import org.cleartk.classifier.feature.function.CharacterNGramFeatureFunction;
import org.cleartk.classifier.feature.function.FeatureFunction;
import org.cleartk.classifier.feature.function.FeatureFunctionExtractor;
import org.cleartk.classifier.feature.function.LowerCaseFeatureFunction;
import org.cleartk.classifier.feature.function.NumericTypeFeatureFunction;
import org.cleartk.token.pos.POSFeatureExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.factory.initializable.Initializable;

public class DefaultFeatureExtractor
implements POSFeatureExtractor<Token, Sentence>,
Initializable {
    private List<SimpleFeatureExtractor> simpleExtractors;
    private List<CleartkExtractor> windowExtractors;
    private List<CleartkExtractor> windowNGramExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.simpleExtractors = new ArrayList<SimpleFeatureExtractor>();
        CoveredTextExtractor wordExtractor = new CoveredTextExtractor();
        CharacterNGramFeatureFunction.Orientation fromLeft = CharacterNGramFeatureFunction.Orientation.LEFT_TO_RIGHT;
        CharacterNGramFeatureFunction.Orientation fromRight = CharacterNGramFeatureFunction.Orientation.RIGHT_TO_LEFT;
        this.simpleExtractors.add((SimpleFeatureExtractor)new FeatureFunctionExtractor((SimpleFeatureExtractor)wordExtractor, new FeatureFunction[]{new LowerCaseFeatureFunction(), new CapitalTypeFeatureFunction(), new NumericTypeFeatureFunction(), new CharacterNGramFeatureFunction(fromLeft, 0, 1), new CharacterNGramFeatureFunction(fromLeft, 0, 2), new CharacterNGramFeatureFunction(fromLeft, 0, 3), new CharacterNGramFeatureFunction(fromRight, 0, 1), new CharacterNGramFeatureFunction(fromRight, 0, 2), new CharacterNGramFeatureFunction(fromRight, 0, 3), new CharacterNGramFeatureFunction(fromRight, 0, 4), new CharacterNGramFeatureFunction(fromRight, 0, 5), new CharacterNGramFeatureFunction(fromRight, 0, 6)}));
        this.windowExtractors = new ArrayList<CleartkExtractor>();
        this.windowExtractors.add(new CleartkExtractor(Token.class, (SimpleFeatureExtractor)wordExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2), new CleartkExtractor.Following(2)}));
        this.windowNGramExtractors = new ArrayList<CleartkExtractor>();
        this.windowNGramExtractors.add(new CleartkExtractor(Token.class, (SimpleFeatureExtractor)wordExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2)}), new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Following(2)})}));
    }

    @Override
    public List<Feature> extractFeatures(JCas jCas, Token token, Sentence sentence) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (SimpleFeatureExtractor simpleFeatureExtractor : this.simpleExtractors) {
            features.addAll(simpleFeatureExtractor.extract(jCas, (Annotation)token));
        }
        for (CleartkExtractor cleartkExtractor : this.windowExtractors) {
            features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
        }
        for (CleartkExtractor cleartkExtractor : this.windowNGramExtractors) {
            features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
        }
        return features;
    }
}

