/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.tokenizer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.tokenizer.Token;
import org.cleartk.token.tokenizer.Tokenizer;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;
import org.uimafit.util.JCasUtil;

public class TokenAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_TOKENIZER_NAME = ConfigurationParameterFactory.createConfigurationParameterName(TokenAnnotator.class, (String)"tokenizerName");
    private static final String TOKENIZER_DESCRIPTION = "specifies the class type of the tokenizer that will be used by this annotator. If this parameter is not filled, then the default tokenenizer (org.cleartk.token.util.PennTreebankTokenizer) is used. A tokenenizer is defined as any implementation of the interface defined by org.cleartk.token.util.Tokenizer.";
    @ConfigurationParameter(description="specifies the class type of the tokenizer that will be used by this annotator. If this parameter is not filled, then the default tokenenizer (org.cleartk.token.util.PennTreebankTokenizer) is used. A tokenenizer is defined as any implementation of the interface defined by org.cleartk.token.util.Tokenizer.", defaultValue={"org.cleartk.token.tokenizer.PennTreebankTokenizer"})
    private String tokenizerName;
    public static final String PARAM_TOKEN_TYPE_NAME = ConfigurationParameterFactory.createConfigurationParameterName(TokenAnnotator.class, (String)"tokenTypeName");
    @ConfigurationParameter(description="class type of the tokens that are created by this annotator. If this parameter is not filled, then tokens of type org.cleartk.token.type.Token will be created.", defaultValue={"org.cleartk.token.type.Token"})
    private String tokenTypeName;
    public static final String PARAM_WINDOW_TYPE_NAME = ConfigurationParameterFactory.createConfigurationParameterName(TokenAnnotator.class, (String)"windowTypeName");
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private String windowTypeName;
    Tokenizer tokenizer;
    Class<? extends Annotation> tokenClass;
    Constructor<? extends Annotation> tokenConstructor;
    private Class<? extends Annotation> windowClass;
    private Type windowType = null;
    private boolean typesInitialized = false;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TokenAnnotator.class, (Object[])new Object[0]);
    }

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        try {
            super.initialize(uimaContext);
            this.tokenizer = (Tokenizer)InitializableFactory.create((UimaContext)uimaContext, (String)this.tokenizerName, Tokenizer.class);
            this.tokenClass = InitializableFactory.getClass((String)this.tokenTypeName, Annotation.class);
            this.tokenConstructor = this.tokenClass.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            if (this.windowTypeName != null) {
                this.windowClass = InitializableFactory.getClass((String)this.windowTypeName, Annotation.class);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void initializeTypes(JCas jCas) {
        if (this.windowClass != null) {
            this.windowType = JCasUtil.getType((JCas)jCas, this.windowClass);
        }
        this.typesInitialized = true;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            if (!this.typesInitialized) {
                this.initializeTypes(jCas);
            }
            if (this.windowType != null) {
                for (Annotation window : jCas.getAnnotationIndex(this.windowType)) {
                    List<Token> pojoTokens = this.tokenizer.getTokens(window.getCoveredText());
                    this.createTokens(pojoTokens, window.getBegin(), jCas);
                }
            } else {
                String text = jCas.getDocumentText();
                List<Token> pojoTokens = this.tokenizer.getTokens(text);
                this.createTokens(pojoTokens, 0, jCas);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void createTokens(List<Token> pojoTokens, int offset, JCas jCas) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        for (Token pojoToken : pojoTokens) {
            int tokenBegin = pojoToken.getBegin() + offset;
            int tokenEnd = pojoToken.getEnd() + offset;
            this.tokenConstructor.newInstance(jCas, tokenBegin, tokenEnd).addToIndexes();
        }
    }

    public void setTokenizerName(String tokenizerName) {
        this.tokenizerName = tokenizerName;
    }

    public void setTokenTypeName(String tokenTypeName) {
        this.tokenTypeName = tokenTypeName;
    }

    public void setWindowTypeName(String windowTypeName) {
        this.windowTypeName = windowTypeName;
    }
}

