/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae.parenthetical;

import java.lang.reflect.Constructor;
import java.util.Stack;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.cleartk.util.CleartkInitializationException;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;
import org.uimafit.util.JCasUtil;

public class ParentheticalAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_WINDOW_TYPE_NAME = ConfigurationParameterFactory.createConfigurationParameterName(ParentheticalAnnotator.class, (String)"windowTypeName");
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. If no value is given, then the entire document will be tokenized at once. ";
    @ConfigurationParameter(description="specifies the class type of annotations that will be tokenized. If no value is given, then the entire document will be tokenized at once. ")
    private String windowTypeName;
    public static final String PARAM_PARENTHETICAL_TYPE_NAME = ConfigurationParameterFactory.createConfigurationParameterName(ParentheticalAnnotator.class, (String)"parentheticalTypeName");
    @ConfigurationParameter(description="class name of the annotations that are created by this annotator.", defaultValue={"org.cleartk.util.type.Parenthetical"}, mandatory=true)
    private String parentheticalTypeName;
    public static final String PARAM_LEFT_PARENTHESIS = ConfigurationParameterFactory.createConfigurationParameterName(ParentheticalAnnotator.class, (String)"leftParenthesis");
    @ConfigurationParameter(defaultValue={"("}, mandatory=true)
    private String leftParenthesis;
    private char leftParen;
    public static final String PARAM_RIGHT_PARENTHESIS = ConfigurationParameterFactory.createConfigurationParameterName(ParentheticalAnnotator.class, (String)"rightParenthesis");
    @ConfigurationParameter(defaultValue={")"}, mandatory=true)
    private String rightParenthesis;
    private char rightParen;
    private Class<? extends Annotation> windowClass;
    private Constructor<? extends Annotation> parentheticalConstructor;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        if (this.windowTypeName != null) {
            this.windowClass = InitializableFactory.getClass((String)this.windowTypeName, Annotation.class);
        }
        if (this.leftParenthesis.length() != 1) {
            throw CleartkInitializationException.notSingleCharacter((String)PARAM_LEFT_PARENTHESIS, (Object)this.leftParenthesis);
        }
        this.leftParen = this.leftParenthesis.charAt(0);
        if (this.rightParenthesis.length() != 1) {
            throw CleartkInitializationException.notSingleCharacter((String)PARAM_RIGHT_PARENTHESIS, (Object)this.rightParenthesis);
        }
        this.rightParen = this.rightParenthesis.charAt(0);
        Class parentheticalClass = InitializableFactory.getClass((String)this.parentheticalTypeName, Annotation.class);
        try {
            this.parentheticalConstructor = parentheticalClass.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (this.windowClass != null) {
            for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
                String text = window.getCoveredText();
                this.createParentheticals(jCas, text, window.getBegin());
            }
        } else {
            String text = jCas.getDocumentText();
            this.createParentheticals(jCas, text, 0);
        }
    }

    private void createParentheticals(JCas jCas, String text, int offset) throws AnalysisEngineProcessException {
        Stack<Integer> leftRoundedParens = new Stack<Integer>();
        leftRoundedParens.clear();
        for (int ci = 0; ci < text.length(); ++ci) {
            Annotation ann;
            char c = text.charAt(ci);
            if (c == this.leftParen) {
                leftRoundedParens.push(ci);
            }
            if (c != this.rightParen || leftRoundedParens.isEmpty()) continue;
            int leftOffset = (Integer)leftRoundedParens.pop();
            try {
                ann = this.parentheticalConstructor.newInstance(jCas, offset + leftOffset, offset + ci + 1);
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ann.addToIndexes();
        }
    }

    @Deprecated
    public static AnalysisEngineDescription getDescription(TypeSystemDescription typeSystemDescription) throws ResourceInitializationException {
        return ParentheticalAnnotator.getDescription(typeSystemDescription, null);
    }

    @Deprecated
    public static AnalysisEngineDescription getDescription(TypeSystemDescription typeSystemDescription, Class<? extends Annotation> windowClass) throws ResourceInitializationException {
        return ParentheticalAnnotator.getDescription(typeSystemDescription, windowClass, '(', ')');
    }

    @Deprecated
    public static AnalysisEngineDescription getDescription(TypeSystemDescription typeSystemDescription, Class<? extends Annotation> windowClass, char leftParen, char rightParen) throws ResourceInitializationException {
        AnalysisEngineDescription aed = AnalysisEngineFactory.createPrimitiveDescription(ParentheticalAnnotator.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{PARAM_LEFT_PARENTHESIS, "" + leftParen, PARAM_RIGHT_PARENTHESIS, "" + rightParen});
        if (windowClass != null) {
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)aed, (Object[])new Object[]{PARAM_WINDOW_TYPE_NAME, windowClass.getName()});
        }
        return aed;
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return ParentheticalAnnotator.getDescription(null, '(', ')');
    }

    public static AnalysisEngineDescription getDescription(Class<? extends Annotation> windowClass) throws ResourceInitializationException {
        return ParentheticalAnnotator.getDescription(windowClass, '(', ')');
    }

    public static AnalysisEngineDescription getDescription(Class<? extends Annotation> windowClass, char leftParen, char rightParen) throws ResourceInitializationException {
        AnalysisEngineDescription aed = AnalysisEngineFactory.createPrimitiveDescription(ParentheticalAnnotator.class, (Object[])new Object[]{PARAM_LEFT_PARENTHESIS, "" + leftParen, PARAM_RIGHT_PARENTHESIS, "" + rightParen});
        if (windowClass != null) {
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)aed, (Object[])new Object[]{PARAM_WINDOW_TYPE_NAME, windowClass.getName()});
        }
        return aed;
    }
}

