/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.compressor.PackCompressorFactory;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.rules.Condition;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackagerBase
implements IPackager {
    public static final String SKELETON_SUBPATH = "lib/installer.jar";
    protected File baseFile = null;
    protected Info info = null;
    protected GUIPrefs guiPrefs = null;
    protected Properties variables = new Properties();
    protected List<Panel> panelList = new ArrayList<Panel>();
    protected List<PackInfo> packsList = new ArrayList<PackInfo>();
    protected List<String> langpackNameList = new ArrayList<String>();
    protected List<CustomData> customDataList = new ArrayList<CustomData>();
    protected Map<String, URL> installerResourceURLMap = new HashMap<String, URL>();
    protected Map<String, Condition> rules = new HashMap<String, Condition>();
    protected Map<String, List<DynamicVariable>> dynamicvariables = new HashMap<String, List<DynamicVariable>>();
    protected Set<Object[]> includedJarURLs = new HashSet<Object[]>();
    protected boolean packJarsSeparate = false;
    protected PackagerListener listener;
    protected PackCompressor compressor;
    protected HashMap<FilterOutputStream, HashSet<String>> alreadyWrittenFiles = new HashMap();
    private List<InstallerRequirement> installerrequirements;

    protected void sendMsg(String string) {
        this.sendMsg(string, 2);
    }

    protected void sendMsg(String string, int n) {
        if (this.listener != null) {
            this.listener.packagerMsg(string, n);
        }
    }

    protected void sendStart() {
        if (this.listener != null) {
            this.listener.packagerStart();
        }
    }

    protected void sendStop() {
        if (this.listener != null) {
            this.listener.packagerStop();
        }
    }

    @Override
    public void addCustomJar(CustomData customData, URL uRL) {
        this.customDataList.add(customData);
        if (uRL != null) {
            this.addJarContent(uRL);
        }
    }

    @Override
    public void addJarContent(URL uRL) {
        this.addJarContent(uRL, null);
    }

    @Override
    public void addJarContent(URL uRL, List<String> list) {
        Object[] objectArray = new Object[]{uRL, list};
        this.sendMsg("Adding content of jar: " + uRL.getFile(), 3);
        this.includedJarURLs.add(objectArray);
    }

    @Override
    public void addLangPack(String string, URL uRL, URL uRL2) {
        this.sendMsg("Adding langpack: " + string, 3);
        this.langpackNameList.add(string);
        this.addResource("flag." + string, uRL2);
        this.installerResourceURLMap.put("langpacks/" + string + ".xml", uRL);
    }

    @Override
    public void addNativeLibrary(String string, URL uRL) throws Exception {
        this.sendMsg("Adding native library: " + string, 3);
        this.installerResourceURLMap.put("native/" + string, uRL);
    }

    @Override
    public void addNativeUninstallerLibrary(CustomData customData) {
        this.customDataList.add(customData);
    }

    @Override
    public void addPack(PackInfo packInfo) {
        this.packsList.add(packInfo);
    }

    @Override
    public void addPanelJar(Panel panel, URL uRL) {
        this.panelList.add(panel);
        if (uRL != null) {
            this.addJarContent(uRL);
        }
    }

    @Override
    public void addResource(String string, URL uRL) {
        this.sendMsg("Adding resource: " + string, 3);
        this.installerResourceURLMap.put("res/" + string, uRL);
    }

    @Override
    public PackCompressor getCompressor() {
        return this.compressor;
    }

    @Override
    public PackagerListener getPackagerListener() {
        return this.listener;
    }

    @Override
    public List<PackInfo> getPacksList() {
        return this.packsList;
    }

    @Override
    public Properties getVariables() {
        return this.variables;
    }

    @Override
    public void initPackCompressor(String string, int n) throws CompilerException {
        this.compressor = PackCompressorFactory.get(string);
        this.compressor.setCompressionLevel(n);
    }

    @Override
    public void setGUIPrefs(GUIPrefs gUIPrefs) {
        this.sendMsg("Setting the GUI preferences", 3);
        this.guiPrefs = gUIPrefs;
    }

    @Override
    public void setInfo(Info info) throws Exception {
        this.sendMsg("Setting the installer information", 3);
        this.info = info;
        if (!this.getCompressor().useStandardCompression() && this.getCompressor().getDecoderMapperName() != null) {
            this.info.setPackDecoderClassName(this.getCompressor().getDecoderMapperName());
        }
    }

    @Override
    public void setPackagerListener(PackagerListener packagerListener) {
        this.listener = packagerListener;
    }

    @Override
    public Map<String, Condition> getRules() {
        return this.rules;
    }

    @Override
    public void setRules(Map<String, Condition> map) {
        this.rules = map;
    }

    protected void writeInstaller() throws Exception {
        this.writeSkeletonInstaller();
        this.writeInstallerObject("info", this.info);
        this.writeInstallerObject("vars", this.variables);
        this.writeInstallerObject("GUIPrefs", this.guiPrefs);
        this.writeInstallerObject("panelsOrder", this.panelList);
        this.writeInstallerObject("customData", this.customDataList);
        this.writeInstallerObject("langpacks.info", this.langpackNameList);
        this.writeInstallerObject("rules", this.rules);
        this.writeInstallerObject("dynvariables", this.dynamicvariables);
        this.writeInstallerObject("installerrequirements", this.installerrequirements);
        this.writeInstallerResources();
        this.writeIncludedJars();
        this.writePacks();
    }

    protected abstract void writeInstallerObject(String var1, Object var2) throws IOException;

    protected abstract void writeSkeletonInstaller() throws IOException;

    protected abstract void writeInstallerResources() throws IOException;

    protected abstract void writeIncludedJars() throws IOException;

    protected abstract void writePacks() throws Exception;

    @Override
    public Map<String, List<DynamicVariable>> getDynamicVariables() {
        return this.dynamicvariables;
    }

    @Override
    public void setDynamicVariables(Map<String, List<DynamicVariable>> map) {
        this.dynamicvariables = map;
    }

    @Override
    public void addInstallerRequirements(List<InstallerRequirement> list) {
        this.installerrequirements = list;
    }
}

