/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jpox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.jpox.DBKeywords;
import org.codehaus.modello.plugin.jpox.metadata.JPoxAssociationMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxClassMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxFieldMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreAssociationMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreFieldMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JPoxJdoMappingModelloGenerator
extends AbstractModelloGenerator {
    private static final Map PRIMITIVE_IDENTITY_MAP = new HashMap();
    private static final List IDENTITY_TYPES;
    private static final List VALUE_STRATEGY_LIST;

    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        try {
            String fileName = this.isPackageWithVersion() ? "package-" + this.getGeneratedVersion() + ".jdo" : "package.jdo";
            File packageJdo = new File(this.getOutputDirectory(), fileName);
            File parent = packageJdo.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new ModelloException("Error while creating parent directories for the file '" + packageJdo.getAbsolutePath() + "'.");
            }
            this.generatePackageJdo(packageJdo, model);
        }
        catch (IOException e) {
            throw new ModelloException("Error while writing package.jdo.", (Throwable)e);
        }
    }

    private void generatePackageJdo(File file, Model model) throws IOException, ModelloException {
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(printWriter);
        HashMap<String, ArrayList<ModelClass>> classes = new HashMap<String, ArrayList<ModelClass>>();
        Iterator<Object> it = model.getClasses(this.getGeneratedVersion()).iterator();
        while (it.hasNext()) {
            ModelClass modelClass = (ModelClass)it.next();
            JPoxClassMetadata jpoxMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
            if (!jpoxMetadata.isEnabled()) continue;
            String packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            ArrayList<ModelClass> list = (ArrayList<ModelClass>)classes.get(packageName);
            if (list == null) {
                list = new ArrayList<ModelClass>();
            }
            list.add(modelClass);
            classes.put(packageName, list);
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<!DOCTYPE jdo PUBLIC");
        printWriter.println("  \"-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.0//EN\"");
        printWriter.println("  \"http://java.sun.com/dtd/jdo_2_0.dtd\">");
        printWriter.println();
        writer.startElement("jdo");
        it = classes.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list.size() == 0) continue;
            String packageName = ((ModelClass)list.get(0)).getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            writer.startElement("package");
            writer.addAttribute("name", packageName);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                ModelClass modelClass = (ModelClass)it2.next();
                this.writeClass((XMLWriter)writer, modelClass);
            }
            writer.endElement();
        }
        writer.endElement();
        printWriter.println();
        printWriter.close();
    }

    private void writeClass(XMLWriter writer, ModelClass modelClass) throws ModelloException {
        ModelField modelField;
        JPoxClassMetadata jpoxMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        if (!jpoxMetadata.isEnabled()) {
            return;
        }
        writer.startElement("class");
        writer.addAttribute("name", modelClass.getName());
        ModelClass persistenceCapableSuperclass = null;
        if (modelClass.hasSuperClass() && modelClass.isInternalSuperClass()) {
            persistenceCapableSuperclass = this.getModel().getClass(modelClass.getSuperClass(), this.getGeneratedVersion());
        }
        if (persistenceCapableSuperclass != null) {
            String superPackageName = persistenceCapableSuperclass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            writer.addAttribute("persistence-capable-superclass", superPackageName + "." + persistenceCapableSuperclass.getName());
        }
        writer.addAttribute("detachable", String.valueOf(jpoxMetadata.isDetachable()));
        if (!StringUtils.isEmpty((String)jpoxMetadata.getTable())) {
            if (DBKeywords.isReserved(jpoxMetadata.getTable())) {
                throw new ModelloException("The JDO mapping generator has detected the use of the SQL Reserved word '" + jpoxMetadata.getTable() + "' as an alternative" + "table name for the " + modelClass.getName() + " class.  Please use" + "a different name for the <class jpox.table=\"" + jpoxMetadata.getTable() + "\"> attribute.  See " + "http://db.apache.org/derby/docs/10.1/ref/rrefkeywords29722.html" + " for complete list.");
            }
            writer.addAttribute("table", jpoxMetadata.getTable());
        } else if (DBKeywords.isReserved(modelClass.getName())) {
            throw new ModelloException("The JDO mapping generator has detected the use of the SQL Reserved word '" + modelClass.getName() + "' as a class name.  " + "Please specify an alternative jpox table name using the " + "<class jpox.table=\"\"> attribute, or use a different class name.  See " + "http://db.apache.org/derby/docs/10.1/ref/rrefkeywords29722.html" + " for complete list.");
        }
        List fields = Collections.unmodifiableList(modelClass.getFields(this.getGeneratedVersion()));
        boolean needInheritance = false;
        if (persistenceCapableSuperclass == null) {
            if (StringUtils.isNotEmpty((String)jpoxMetadata.getIdentityType())) {
                String identityType = jpoxMetadata.getIdentityType();
                if (!IDENTITY_TYPES.contains(identityType)) {
                    throw new ModelloException("The JDO mapping generator does not support the specified class identity type '" + identityType + "'. " + "Supported types: " + IDENTITY_TYPES);
                }
                writer.addAttribute("identity-type", identityType);
            } else if (this.isInstantionApplicationType(modelClass)) {
                writer.addAttribute("identity-type", "application");
            }
        } else {
            needInheritance = true;
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getIdentityClass())) {
            writer.addAttribute("objectid-class", jpoxMetadata.getIdentityClass());
        } else {
            String objectIdClass;
            List primaryKeys = this.getPrimaryKeyFields(modelClass);
            if (primaryKeys.size() > 1) {
                throw new ModelloException("The JDO mapping generator does not yet support Object Identifier generation for the " + primaryKeys.size() + " fields specified as <identifier> or " + "with jpox.primary-key=\"true\"");
            }
            if (primaryKeys.size() == 1 && StringUtils.isNotEmpty((String)(objectIdClass = (String)PRIMITIVE_IDENTITY_MAP.get((modelField = (ModelField)primaryKeys.get(0)).getType())))) {
                writer.addAttribute("objectid-class", objectIdClass);
            }
        }
        if (needInheritance) {
            writer.startElement("inheritance");
            writer.addAttribute("strategy", "new-table");
            writer.endElement();
        }
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            modelField = (ModelField)it.next();
            this.writeModelField(writer, modelField);
        }
        List ignoredFields = jpoxMetadata.getNotPersisted();
        if (ignoredFields != null) {
            Iterator it2 = ignoredFields.iterator();
            while (it2.hasNext()) {
                String fieldName = (String)it2.next();
                writer.startElement("field");
                writer.addAttribute("name", fieldName);
                writer.addAttribute("persistence-modifier", "none");
                writer.endElement();
            }
        }
        ArrayList<ModelField> detailedFields = new ArrayList<ModelField>();
        Iterator it3 = fields.iterator();
        while (it3.hasNext()) {
            StoreAssociationMetadata storeMetadata;
            ModelField field = (ModelField)it3.next();
            if (field.isPrimitive() || field instanceof ModelAssociation && (storeMetadata = this.getAssociationMetadata((ModelAssociation)field)).isPart() != null && storeMetadata.isPart().booleanValue()) continue;
            detailedFields.add(field);
        }
        this.writeFetchGroup(writer, modelClass.getName() + "_detail", detailedFields, true);
        HashMap fetchsMap = new HashMap();
        Iterator<Object> it4 = fields.iterator();
        while (it4.hasNext()) {
            ModelField field = (ModelField)it4.next();
            JPoxFieldMetadata jpoxFieldMetadata = (JPoxFieldMetadata)field.getMetadata(JPoxFieldMetadata.ID);
            List names = jpoxFieldMetadata.getFetchGroupNames();
            if (names == null) continue;
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String fetchGroupName = (String)i.next();
                List fetchList = fetchsMap.get(fetchGroupName) == null ? new ArrayList() : (List)fetchsMap.get(fetchGroupName);
                fetchList.add(field);
                fetchsMap.put(fetchGroupName, fetchList);
            }
        }
        it4 = fetchsMap.keySet().iterator();
        while (it4.hasNext()) {
            String fetchName = (String)it4.next();
            this.writeFetchGroup(writer, fetchName, (List)fetchsMap.get(fetchName), false);
        }
        writer.endElement();
    }

    private void writeFetchGroup(XMLWriter writer, String fetchGroupName, List fields, boolean onlyIfIsStashPart) {
        if (!fields.isEmpty()) {
            writer.startElement("fetch-group");
            writer.addAttribute("name", fetchGroupName);
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                StoreAssociationMetadata storeMetadata;
                ModelField field = (ModelField)it.next();
                if (onlyIfIsStashPart && field instanceof ModelAssociation && (storeMetadata = this.getAssociationMetadata((ModelAssociation)field)).isPart() != null && storeMetadata.isPart().booleanValue()) continue;
                writer.startElement("field");
                writer.addAttribute("name", field.getName());
                writer.endElement();
            }
            writer.endElement();
        }
    }

    private void writeModelField(XMLWriter writer, ModelField modelField) throws ModelloException {
        writer.startElement("field");
        StoreFieldMetadata storeMetadata = (StoreFieldMetadata)modelField.getMetadata(StoreFieldMetadata.ID);
        JPoxFieldMetadata jpoxMetadata = (JPoxFieldMetadata)modelField.getMetadata(JPoxFieldMetadata.ID);
        writer.addAttribute("name", modelField.getName());
        if (!storeMetadata.isStorable()) {
            writer.addAttribute("persistence-modifier", "none");
        } else if (StringUtils.isNotEmpty((String)jpoxMetadata.getPersistenceModifier())) {
            writer.addAttribute("persistence-modifier", jpoxMetadata.getPersistenceModifier());
        }
        if (modelField.isRequired()) {
            writer.addAttribute("null-value", "exception");
        } else if (jpoxMetadata.getNullValue() != null) {
            writer.addAttribute("null-value", jpoxMetadata.getNullValue());
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getColumnName())) {
            if (DBKeywords.isReserved(jpoxMetadata.getColumnName())) {
                throw new ModelloException("The JDO mapping generator has detected the use of the SQL Reserved word '" + jpoxMetadata.getColumnName() + "' as an alternative" + "column name for the " + modelField.getName() + " field of the " + modelField.getModelClass().getName() + " class.  Please use" + "a different name for the <field jpox.column=\"" + jpoxMetadata.getColumnName() + "\"> attribute.  See " + "http://db.apache.org/derby/docs/10.1/ref/rrefkeywords29722.html" + " for complete list.");
            }
            writer.addAttribute("column", jpoxMetadata.getColumnName());
        } else if (DBKeywords.isReserved(modelField.getName())) {
            throw new ModelloException("The JDO mapping generator has detected the use of the SQL Reserved word '" + modelField.getName() + "' as a field name of the " + modelField.getModelClass().getName() + " class.  Please specify an " + "alternative jpox column name using the <field jpox.column=\"\"> " + "attribute, or use a different class name.  See " + "http://db.apache.org/derby/docs/10.1/ref/rrefkeywords29722.html" + " for complete list.");
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getJoinTableName())) {
            if (DBKeywords.isReserved(jpoxMetadata.getJoinTableName())) {
                throw new ModelloException("The JDO mapping generator has detected the use of the SQL Reserved word '" + jpoxMetadata.getJoinTableName() + "' as name of a" + "join table for the " + modelField.getName() + " field of the " + modelField.getModelClass().getName() + " class.  Please specify" + "an alternative name for the <field jpox.join-table=\"" + jpoxMetadata.getColumnName() + "\"> attribute.  See " + "http://db.apache.org/derby/docs/10.1/ref/rrefkeywords29722.html" + " for complete list.");
            }
            writer.addAttribute("table", jpoxMetadata.getJoinTableName());
        }
        if (jpoxMetadata.isPrimaryKey()) {
            writer.addAttribute("primary-key", "true");
            if (StringUtils.isNotEmpty((String)jpoxMetadata.getValueStrategy())) {
                String valueStrategy = jpoxMetadata.getValueStrategy();
                if (!VALUE_STRATEGY_LIST.contains(valueStrategy)) {
                    throw new ModelloException("The JDO mapping generator does not support the specified value-strategy '" + valueStrategy + "'. " + "Supported types: " + VALUE_STRATEGY_LIST);
                }
                writer.addAttribute("value-strategy", jpoxMetadata.getValueStrategy());
            }
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getIndexed())) {
            writer.addAttribute("indexed", jpoxMetadata.getIndexed());
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getMappedBy())) {
            writer.addAttribute("mapped-by", jpoxMetadata.getMappedBy());
        }
        if (modelField instanceof ModelAssociation) {
            this.writeAssociation(writer, (ModelAssociation)modelField);
        } else {
            if (modelField.isPrimitiveArray()) {
                writer.startElement("array");
                writer.endElement();
            }
            if (storeMetadata.getMaxSize() > 0 || jpoxMetadata.getNullValue() != null && modelField.getDefaultValue() != null) {
                writer.startElement("column");
                if (storeMetadata.getMaxSize() > 0) {
                    writer.addAttribute("length", String.valueOf(storeMetadata.getMaxSize()));
                }
                if (jpoxMetadata.getNullValue() != null && "default".equals(jpoxMetadata.getNullValue())) {
                    writer.addAttribute("default-value", modelField.getDefaultValue());
                }
                writer.endElement();
            }
        }
        writer.endElement();
    }

    private void writeAssociation(XMLWriter writer, ModelAssociation association) {
        StoreAssociationMetadata am = (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
        JPoxAssociationMetadata jpoxMetadata = (JPoxAssociationMetadata)association.getAssociationMetadata(JPoxAssociationMetadata.ID);
        if (am.isPart() != null) {
            writer.addAttribute("default-fetch-group", am.isPart().toString());
        }
        if (association.getType().equals("java.util.List") || association.getType().equals("java.util.Set")) {
            writer.startElement("collection");
            if (association.getTo().equals("String")) {
                writer.addAttribute("element-type", "java.lang.String");
            } else {
                writer.addAttribute("element-type", association.getTo());
            }
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-element", "true");
            } else {
                writer.addAttribute("dependent-element", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Map")) {
            writer.startElement("map");
            writer.addAttribute("key-type", am.getKeyType());
            if (association.getTo().equals("String")) {
                writer.addAttribute("value-type", "java.lang.String");
            } else {
                writer.addAttribute("value-type", association.getTo());
            }
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-key", "true");
                writer.addAttribute("dependent-value", "true");
            } else {
                writer.addAttribute("dependent-key", "false");
                writer.addAttribute("dependent-value", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Properties")) {
            writer.addAttribute("embedded", "false");
            writer.startElement("map");
            writer.addAttribute("key-type", "java.lang.String");
            writer.addAttribute("value-type", "java.lang.String");
            writer.addAttribute("embedded-key", "true");
            writer.addAttribute("embedded-value", "true");
            writer.addAttribute("dependent-key", "true");
            writer.addAttribute("dependent-value", "true");
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (jpoxMetadata.isDependent()) {
            writer.addAttribute("dependent", "true");
        }
    }

    private void writeExtension(XMLWriter writer, String vendorName, String key, String value) {
        writer.startElement("extension");
        writer.addAttribute("vendor-name", vendorName);
        writer.addAttribute("key", key);
        writer.addAttribute("value", value);
        writer.endElement();
    }

    private boolean isInstantionApplicationType(ModelClass modelClass) {
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        return identifierFields.size() > 0;
    }

    private List getPrimaryKeyFields(ModelClass modelClass) throws ModelloException {
        ArrayList<ModelField> primaryKeys = new ArrayList<ModelField>();
        List fields = modelClass.getFields(this.getGeneratedVersion());
        JPoxClassMetadata jpoxClassMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            ModelField modelField = (ModelField)it.next();
            JPoxFieldMetadata jpoxFieldMetadata = (JPoxFieldMetadata)modelField.getMetadata(JPoxFieldMetadata.ID);
            if (jpoxClassMetadata.useIdentifiersAsPrimaryKey()) {
                if (!modelField.isIdentifier()) continue;
                this.assertSupportedIdentityPrimitive(modelField);
                primaryKeys.add(modelField);
                continue;
            }
            if (!jpoxFieldMetadata.isPrimaryKey()) continue;
            this.assertSupportedIdentityPrimitive(modelField);
            primaryKeys.add(modelField);
        }
        return primaryKeys;
    }

    private void assertSupportedIdentityPrimitive(ModelField modelField) throws ModelloException {
        if (!PRIMITIVE_IDENTITY_MAP.containsKey(modelField.getType())) {
            throw new ModelloException("The JDO mapping generator does not support the specified field type '" + modelField.getType() + "'. " + "Supported types: " + PRIMITIVE_IDENTITY_MAP.keySet());
        }
    }

    private StoreAssociationMetadata getAssociationMetadata(ModelAssociation association) {
        return (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
    }

    static {
        PRIMITIVE_IDENTITY_MAP.put("short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("int", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Integer", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("String", "javax.jdo.identity.StringIdentity");
        PRIMITIVE_IDENTITY_MAP.put("char", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Character", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("byte", "javax.jdo.identity.ByteIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Byte", "javax.jdo.identity.ByteIdentity");
        IDENTITY_TYPES = new ArrayList();
        IDENTITY_TYPES.add("application");
        IDENTITY_TYPES.add("datastore");
        IDENTITY_TYPES.add("nondurable");
        VALUE_STRATEGY_LIST = new ArrayList();
        VALUE_STRATEGY_LIST.add("off");
        VALUE_STRATEGY_LIST.add("native");
        VALUE_STRATEGY_LIST.add("sequence");
        VALUE_STRATEGY_LIST.add("identity");
        VALUE_STRATEGY_LIST.add("increment");
        VALUE_STRATEGY_LIST.add("uuid-string");
        VALUE_STRATEGY_LIST.add("uuid-hex");
        VALUE_STRATEGY_LIST.add("datastore-uuid-hex");
        VALUE_STRATEGY_LIST.add("max");
        VALUE_STRATEGY_LIST.add("auid");
    }
}

