/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class CreateRepositoryMojo
extends AbstractMojo {
    private File assembleDirectory;
    private String repoPath;
    private String repositoryLayout;
    private Set artifacts;
    private String pluginVersion;
    private ArtifactRepository localRepository;
    private Artifact projectArtifact;
    private boolean installBooterArtifacts;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactInstaller artifactInstaller;
    private Map availableRepositoryLayouts;
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource metadataSource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactRepositoryLayout artifactRepositoryLayout = (ArtifactRepositoryLayout)this.availableRepositoryLayouts.get(this.repositoryLayout);
        if (artifactRepositoryLayout == null) {
            throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
        }
        String path = "file://" + this.assembleDirectory.getAbsolutePath() + "/" + this.repoPath;
        ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", path, artifactRepositoryLayout, false);
        this.installArtifact(this.projectArtifact, artifactRepository);
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.installArtifact(artifact, artifactRepository);
        }
        if (this.installBooterArtifacts) {
            this.installBooterArtifacts(artifactRepository);
        }
    }

    private void installBooterArtifacts(ArtifactRepository artifactRepository) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createDependencyArtifact("org.codehaus.mojo.appassembler", "appassembler-booter", VersionRange.createFromVersion((String)this.pluginVersion), "jar", null, "runtime");
        try {
            Artifact p = this.artifactFactory.createBuildArtifact("org.codehaus.mojo.appassembler", "appassembler-maven-plugin", this.pluginVersion, "jar");
            ExcludesArtifactFilter filter = new ExcludesArtifactFilter(Collections.singletonList("junit:junit"));
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(Collections.singleton(artifact), p, this.localRepository, Collections.EMPTY_LIST, this.metadataSource, (ArtifactFilter)filter);
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                this.installArtifact(a, artifactRepository);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }

    private void installArtifact(Artifact artifact, ArtifactRepository artifactRepository) throws MojoExecutionException {
        if (artifact.getFile() != null) {
            try {
                artifact.isSnapshot();
                this.artifactInstaller.install(artifact.getFile(), artifact, artifactRepository);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
            }
        }
    }

    public void setAvailableRepositoryLayouts(Map availableRepositoryLayouts) {
        this.availableRepositoryLayouts = availableRepositoryLayouts;
    }
}

