/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.merge;

import java.util.List;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.merge.DaemonMerger;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class DefaultDaemonMerger
extends AbstractLogEnabled
implements DaemonMerger {
    public Daemon mergeDaemons(Daemon dominant, Daemon recessive) throws DaemonGeneratorException {
        if (dominant == null) {
            return recessive;
        }
        if (recessive == null) {
            return dominant;
        }
        Daemon result = new Daemon();
        result.setId(this.select(dominant.getId(), recessive.getId()));
        result.setMainClass(this.select(dominant.getMainClass(), recessive.getMainClass()));
        result.setClasspath((Classpath)this.select(dominant.getClasspath(), recessive.getClasspath()));
        result.setCommandLineArguments(this.select(dominant.getCommandLineArguments(), recessive.getCommandLineArguments()));
        result.setJvmSettings((JvmSettings)this.select(dominant.getJvmSettings(), recessive.getJvmSettings()));
        result.setShowConsoleWindow(dominant.isShowConsoleWindow());
        return result;
    }

    private String select(String dominant, String recessive) {
        if (StringUtils.isNotEmpty((String)dominant)) {
            return dominant;
        }
        return recessive;
    }

    private List select(List dominant, List recessive) {
        if (dominant != null && dominant.size() > 0) {
            return dominant;
        }
        return recessive;
    }

    private Object select(Object dominant, Object recessive) {
        if (dominant != null) {
            return dominant;
        }
        return recessive;
    }
}

