/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.jsw;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.util.FormattedProperties;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;

public class JavaServiceWrapperDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    private static final Map jswPlatformsMap = new HashMap(){
        {
            this.put("linux-x86-32-lib", "lib/libwrapper-linux-x86-32.so");
            this.put("linux-x86-32-exec", "bin/wrapper-linux-x86-32");
            this.put("linux-x86-64-lib", "lib/libwrapper-linux-x86-64.so");
            this.put("linux-x86-64-exec", "bin/wrapper-linux-x86-64");
            this.put("linux-ppc-64-lib", "lib/libwrapper-linux-ppc-64.so");
            this.put("linux-ppc-64-exec", "bin/wrapper-linux-ppc-64");
            this.put("macosx-ppc-32-lib", "lib/libwrapper-macosx-ppc-32.jnilib");
            this.put("macosx-ppc-32-exec", "bin/wrapper-macosx-ppc-32");
            this.put("macosx-x86-universal-32-lib", "lib/libwrapper-macosx-universal-32.jnilib");
            this.put("macosx-x86-universal-32-exec", "bin/wrapper-macosx-universal-32");
            this.put("solaris-sparc-32-lib", "lib/libwrapper-solaris-sparc-32.so");
            this.put("solaris-sparc-32-exec", "bin/wrapper-solaris-sparc-32");
            this.put("solaris-sparc-64-lib", "lib/libwrapper-solaris-sparc-64.so");
            this.put("solaris-sparc-64-exec", "bin/wrapper-solaris-sparc-64");
            this.put("solaris-x86-32-lib", "lib/libwrapper-solaris-x86-32.so");
            this.put("solaris-x86-32-exec", "bin/wrapper-solaris-x86-32");
            this.put("windows-x86-32-lib", "lib/wrapper-windows-x86-32.dll");
            this.put("windows-x86-32-exec", "bin/wrapper-windows-x86-32.exe");
        }
    };

    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon daemon = request.getDaemon();
        File outputDirectory = new File(request.getOutputDirectory(), daemon.getId());
        Properties configuration = this.createConfiguration(daemon);
        String appBaseEnvVar = configuration.getProperty("app.base.envvar", "APP_BASE");
        ((Hashtable)configuration).remove("app.base.envvar");
        Properties context = JavaServiceWrapperDaemonGenerator.createContext(request, daemon);
        context.setProperty("app.base.envvar", appBaseEnvVar);
        this.writeWrapperConfFile(request, daemon, outputDirectory, context, configuration);
        this.writeScriptFiles(request, daemon, outputDirectory, context);
        List jswPlatformIncludes = this.getJswPlatformIncludes(daemon);
        this.writeLibraryFiles(outputDirectory, jswPlatformIncludes);
        this.writeExecutableFiles(outputDirectory, jswPlatformIncludes);
    }

    private void writeWrapperConfFile(DaemonGenerationRequest request, Daemon daemon, File outputDirectory, Properties context, Properties configuration) throws DaemonGeneratorException {
        InputStream in = this.getClass().getResourceAsStream("conf/wrapper.conf.in");
        if (in == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        FormattedProperties confFile = new FormattedProperties();
        try {
            confFile.read(in);
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error reading template: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
        confFile.setPropertyAfter("wrapper.working.dir", "..", "wrapper.java.command");
        confFile.setProperty("wrapper.java.library.path.1", "lib");
        confFile.setPropertyAfter("set.default.REPO_DIR", "repo", "wrapper.java.mainclass");
        confFile.setPropertyAfter("set.default." + context.getProperty("app.base.envvar"), ".", "wrapper.java.mainclass");
        if (daemon.getJvmSettings() != null && !StringUtils.isEmpty((String)daemon.getJvmSettings().getInitialMemorySize())) {
            confFile.setProperty("wrapper.java.initmemory", daemon.getJvmSettings().getInitialMemorySize());
        }
        if (daemon.getJvmSettings() != null && !StringUtils.isEmpty((String)daemon.getJvmSettings().getMaxMemorySize())) {
            confFile.setProperty("wrapper.java.maxmemory", daemon.getJvmSettings().getMaxMemorySize());
        }
        confFile.setProperty("wrapper.app.parameter.1", daemon.getMainClass());
        JavaServiceWrapperDaemonGenerator.createClasspath(request, confFile, configuration);
        JavaServiceWrapperDaemonGenerator.createAdditional(daemon, confFile);
        JavaServiceWrapperDaemonGenerator.createParameters(daemon, confFile);
        Iterator i = ((Hashtable)configuration).entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.length() > 0) {
                confFile.setProperty(key, value);
                continue;
            }
            confFile.removeProperty(key);
        }
        StringOutputStream string = new StringOutputStream();
        confFile.save((OutputStream)string);
        InputStreamReader reader = new InputStreamReader((InputStream)new StringInputStream(string.toString()));
        JavaServiceWrapperDaemonGenerator.writeFilteredFile(request, daemon, reader, new File(outputDirectory, "conf/wrapper.conf"), context);
    }

    private Properties createConfiguration(Daemon daemon) {
        Properties configuration = new Properties();
        Iterator i = daemon.getGeneratorConfigurations().iterator();
        while (i.hasNext()) {
            GeneratorConfiguration generatorConfiguration = (GeneratorConfiguration)i.next();
            if (!generatorConfiguration.getGenerator().equals("jsw")) continue;
            ((Hashtable)configuration).putAll(generatorConfiguration.getConfiguration());
        }
        return configuration;
    }

    private static void writeFilteredFile(DaemonGenerationRequest request, Daemon daemon, Reader reader, File outputFile, Map context) throws DaemonGeneratorException {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, context, "@", "@");
        JavaServiceWrapperDaemonGenerator.writeFile(outputFile, (Reader)interpolationFilterReader);
    }

    private static Properties createContext(DaemonGenerationRequest request, Daemon daemon) {
        Properties context = new Properties();
        context.setProperty("app.long.name", request.getMavenProject().getName());
        context.setProperty("app.name", daemon.getId());
        String description = request.getMavenProject().getDescription();
        if (description == null) {
            description = request.getMavenProject().getName();
        }
        context.setProperty("app.description", description);
        return context;
    }

    private static void writeFile(File outputFile, Reader reader) throws DaemonGeneratorException {
        FileWriter out = null;
        try {
            outputFile.getParentFile().mkdirs();
            out = new FileWriter(outputFile);
            IOUtil.copy((Reader)reader, (Writer)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing output file: " + outputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Reader)reader);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Writer)out);
    }

    private static void writeFile(File outputFile, InputStream inputStream) throws DaemonGeneratorException {
        FileOutputStream out = null;
        try {
            outputFile.getParentFile().mkdirs();
            out = new FileOutputStream(outputFile);
            IOUtil.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing output file: " + outputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)inputStream);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inputStream);
        IOUtil.close((OutputStream)out);
    }

    private static void createClasspath(DaemonGenerationRequest request, FormattedProperties confFile, Properties configuration) {
        String wrapperClassPathPrefix = "wrapper.java.classpath.";
        int counter = 1;
        confFile.setProperty("wrapper.java.classpath." + counter++, "lib/wrapper.jar");
        String configurationDirFirst = configuration.getProperty("configuration.directory.in.classpath.first");
        if (configurationDirFirst != null) {
            confFile.setProperty("wrapper.java.classpath." + counter++, configurationDirFirst);
        }
        MavenProject project = request.getMavenProject();
        ArtifactRepositoryLayout layout = request.getRepositoryLayout();
        confFile.setProperty("wrapper.java.classpath." + counter++, "%REPO_DIR%/" + JavaServiceWrapperDaemonGenerator.createDependency(layout, project.getArtifact()).getRelativePath());
        Iterator j = project.getRuntimeArtifacts().iterator();
        while (j.hasNext()) {
            Artifact artifact = (Artifact)j.next();
            confFile.setProperty("wrapper.java.classpath." + counter, "%REPO_DIR%/" + JavaServiceWrapperDaemonGenerator.createDependency(layout, artifact).getRelativePath());
            ++counter;
        }
        String configurationDirLast = configuration.getProperty("configuration.directory.in.classpath.last");
        if (configurationDirLast != null) {
            confFile.setProperty("wrapper.java.classpath." + counter++, configurationDirLast);
        }
    }

    private static Dependency createDependency(ArtifactRepositoryLayout layout, Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setGroupId(artifact.getGroupId());
        dependency.setVersion(artifact.getVersion());
        dependency.setRelativePath(layout.pathOf(artifact));
        return dependency;
    }

    private static void createAdditional(Daemon daemon, FormattedProperties confFile) {
        if (daemon.getJvmSettings() != null) {
            int count = 1;
            Iterator i = daemon.getJvmSettings().getSystemProperties().iterator();
            while (i.hasNext()) {
                String systemProperty = (String)i.next();
                confFile.setProperty("wrapper.java.additional." + count, "-D" + systemProperty);
                ++count;
            }
            i = daemon.getJvmSettings().getExtraArguments().iterator();
            while (i.hasNext()) {
                String extraArgument = (String)i.next();
                confFile.setProperty("wrapper.java.additional." + count, extraArgument);
                ++count;
            }
        }
    }

    private static void createParameters(Daemon daemon, FormattedProperties confFile) {
        int count = 2;
        Iterator i = daemon.getCommandLineArguments().iterator();
        while (i.hasNext()) {
            String argument = (String)i.next();
            confFile.setProperty("wrapper.app.parameter." + count, argument);
            ++count;
        }
    }

    private void writeScriptFiles(DaemonGenerationRequest request, Daemon daemon, File outputDirectory, Properties context) throws DaemonGeneratorException {
        InputStream shellScriptInputStream = this.getClass().getResourceAsStream("bin/sh.script.in");
        if (shellScriptInputStream == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        InputStreamReader reader = new InputStreamReader(shellScriptInputStream);
        JavaServiceWrapperDaemonGenerator.writeFilteredFile(request, daemon, reader, new File(outputDirectory, "bin/" + daemon.getId()), context);
        InputStream batchFileInputStream = this.getClass().getResourceAsStream("bin/AppCommand.bat.in");
        if (batchFileInputStream == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        JavaServiceWrapperDaemonGenerator.writeFile(new File(outputDirectory, "bin/" + daemon.getId() + ".bat"), batchFileInputStream);
    }

    private void writeLibraryFiles(File outputDirectory, List jswPlatformIncludes) throws DaemonGeneratorException {
        this.copyResourceFile(outputDirectory, "lib/wrapper.jar");
        Iterator iter = jswPlatformIncludes.iterator();
        while (iter.hasNext()) {
            String platform = (String)iter.next();
            String libFile = (String)jswPlatformsMap.get(platform + "-lib");
            if (libFile != null) {
                this.copyResourceFile(outputDirectory, libFile);
                continue;
            }
            this.getLogger().warn("Lib file for " + platform + " not found in map.");
        }
    }

    private void writeExecutableFiles(File outputDirectory, List jswPlatformIncludes) throws DaemonGeneratorException {
        Iterator iter = jswPlatformIncludes.iterator();
        while (iter.hasNext()) {
            String platform = (String)iter.next();
            String execFile = (String)jswPlatformsMap.get(platform + "-exec");
            if (execFile != null) {
                this.copyResourceFile(outputDirectory, execFile);
                continue;
            }
            this.getLogger().warn("Exec file for " + platform + " not found in map.");
        }
    }

    private void copyResourceFile(File outputDirectory, String fileName) throws DaemonGeneratorException {
        InputStream batchFileInputStream = this.getClass().getResourceAsStream(fileName);
        if (batchFileInputStream == null) {
            throw new DaemonGeneratorException("Could not load library file: " + fileName);
        }
        JavaServiceWrapperDaemonGenerator.writeFile(new File(outputDirectory, fileName), batchFileInputStream);
    }

    private List getJswPlatformIncludes(Daemon daemon) {
        List<String> jswPlatformIncludes = null;
        Iterator i = daemon.getGeneratorConfigurations().iterator();
        while (i.hasNext()) {
            GeneratorConfiguration generatorConfiguration = (GeneratorConfiguration)i.next();
            if (!generatorConfiguration.getGenerator().equals("jsw")) continue;
            jswPlatformIncludes = generatorConfiguration.getIncludes();
        }
        if (jswPlatformIncludes == null || jswPlatformIncludes.isEmpty()) {
            jswPlatformIncludes = new ArrayList<String>();
            jswPlatformIncludes.add("linux-x86-32");
            jswPlatformIncludes.add("macosx-x86-universal-32");
            jswPlatformIncludes.add("solaris-x86-32");
            jswPlatformIncludes.add("windows-x86-32");
        }
        return jswPlatformIncludes;
    }
}

