/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.booter;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.model.io.stax.AppassemblerModelStaxReader;

public class AppassemblerBooter {
    private static boolean debug;
    private static Daemon config;
    private static String mainClassName;

    public static void main(String[] args) throws Exception {
        URLClassLoader classLoader = AppassemblerBooter.setup();
        AppassemblerBooter.executeMain(classLoader, args);
    }

    public static URLClassLoader setup() throws IOException, XMLStreamException {
        String appName = System.getProperty("app.name");
        if (appName == null) {
            throw new RuntimeException("Missing required system property 'app.name'.");
        }
        debug = Boolean.getBoolean("app.booter.debug");
        String b = System.getProperty("basedir");
        if (b == null) {
            throw new RuntimeException("Missing required system property 'basedir'.");
        }
        String r = System.getProperty("app.repo", b);
        File repoDir = new File(r);
        config = AppassemblerBooter.loadConfig(appName);
        mainClassName = config.getMainClass();
        if (AppassemblerBooter.isEmpty(mainClassName)) {
            throw new RuntimeException("Missing required property from configuration: 'mainClass'.");
        }
        AppassemblerBooter.setSystemProperties();
        return AppassemblerBooter.createClassLoader(repoDir);
    }

    public static URLClassLoader createClassLoader(File repoDir) throws MalformedURLException {
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        List classPathElements = config.getAllClasspathElements();
        Iterator iter = classPathElements.iterator();
        while (iter.hasNext()) {
            ClasspathElement element = (ClasspathElement)iter.next();
            File artifact = new File(repoDir, element.getRelativePath());
            if (debug) {
                System.err.println("Adding file to classpath: " + artifact.getAbsolutePath());
            }
            classpathUrls.add(artifact.toURL());
        }
        URL[] urls = classpathUrls.toArray(new URL[classpathUrls.size()]);
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    public static void setSystemProperties() {
        JvmSettings jvmSettings = config.getJvmSettings();
        if (jvmSettings != null && jvmSettings.getSystemProperties() != null) {
            List systemProperties = jvmSettings.getSystemProperties();
            Iterator i = systemProperties.iterator();
            while (i.hasNext()) {
                String line = (String)i.next();
                try {
                    String[] strings = line.split("=");
                    String key = strings[0];
                    String value = strings[1];
                    if (debug) {
                        System.err.println("Setting system property '" + key + "' to '" + value + "'.");
                    }
                    System.setProperty(key, value);
                }
                catch (Throwable e) {
                    if (!debug) continue;
                    System.err.println("Error Setting system property with value '" + line + "'.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Daemon loadConfig(String appName) throws IOException, XMLStreamException {
        String resourceName = "/" + appName + ".xml";
        InputStream resource = AppassemblerBooter.class.getResourceAsStream(resourceName);
        if (debug) {
            System.err.println("Loading configuration file from: " + resourceName);
        }
        if (resource == null) {
            throw new RuntimeException("Could not load configuration resource: '" + resourceName + "'.");
        }
        try {
            AppassemblerModelStaxReader reader = new AppassemblerModelStaxReader();
            Daemon daemon = reader.read((Reader)new InputStreamReader(resource));
            return daemon;
        }
        finally {
            resource.close();
        }
    }

    public static void executeMain(URLClassLoader classLoader, String[] args) throws Exception {
        List<String> arguments = config.getCommandLineArguments();
        Class<?> mainClass = classLoader.loadClass(mainClassName);
        Method main = mainClass.getMethod("main", String;.class);
        if (arguments == null) {
            arguments = Arrays.asList(args);
        } else {
            arguments.addAll(Arrays.asList(args));
        }
        String[] commandLineArgs = arguments.toArray(new String[0]);
        Thread.currentThread().setContextClassLoader(classLoader);
        main.invoke(null, new Object[]{commandLineArgs});
    }

    private static boolean isEmpty(String mainClass) {
        return mainClass == null || mainClass.trim().length() == 0;
    }
}

