/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.model.io.stax;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class AppassemblerModelStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, Daemon daemon) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(daemon.getModelEncoding(), "1.0");
        this.writeDaemon(daemon, "daemon", (XMLStreamWriter)serializer);
        serializer.writeEndDocument();
    }

    private void writeClasspath(Classpath classpath, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (classpath != null) {
            ClasspathElement o;
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (classpath.getDependencies() != null && classpath.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                iter = classpath.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            if (classpath.getDirectories() != null && classpath.getDirectories().size() > 0) {
                serializer.writeStartElement("directories");
                iter = classpath.getDirectories().iterator();
                while (iter.hasNext()) {
                    o = (Directory)iter.next();
                    this.writeDirectory((Directory)o, "directory", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeClasspathElement(ClasspathElement classpathElement, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (classpathElement != null) {
            serializer.writeStartElement(tagName);
            if (classpathElement.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(classpathElement.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDaemon(Daemon daemon, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (daemon != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (daemon.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(daemon.getId());
                serializer.writeEndElement();
            }
            if (daemon.getMainClass() != null) {
                serializer.writeStartElement("mainClass");
                serializer.writeCharacters(daemon.getMainClass());
                serializer.writeEndElement();
            }
            if (daemon.getClasspath() != null) {
                this.writeClasspath(daemon.getClasspath(), "classpath", serializer);
            }
            if (daemon.getCommandLineArguments() != null && daemon.getCommandLineArguments().size() > 0) {
                serializer.writeStartElement("commandLineArguments");
                iter = daemon.getCommandLineArguments().iterator();
                while (iter.hasNext()) {
                    String commandLineArgument = (String)iter.next();
                    serializer.writeStartElement("commandLineArgument");
                    serializer.writeCharacters(commandLineArgument);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (daemon.getJvmSettings() != null) {
                this.writeJvmSettings(daemon.getJvmSettings(), "jvmSettings", serializer);
            }
            if (daemon.getEnvironmentSetupFileName() != null) {
                serializer.writeStartElement("environmentSetupFileName");
                serializer.writeCharacters(daemon.getEnvironmentSetupFileName());
                serializer.writeEndElement();
            }
            if (!daemon.isShowConsoleWindow()) {
                serializer.writeStartElement("showConsoleWindow");
                serializer.writeCharacters(String.valueOf(daemon.isShowConsoleWindow()));
                serializer.writeEndElement();
            }
            if (daemon.getGeneratorConfigurations() != null && daemon.getGeneratorConfigurations().size() > 0) {
                serializer.writeStartElement("generatorConfigurations");
                iter = daemon.getGeneratorConfigurations().iterator();
                while (iter.hasNext()) {
                    GeneratorConfiguration o = (GeneratorConfiguration)iter.next();
                    this.writeGeneratorConfiguration(o, "generatorConfiguration", serializer);
                }
                serializer.writeEndElement();
            }
            if (daemon.getRepositoryName() != null && !daemon.getRepositoryName().equals("repo")) {
                serializer.writeStartElement("repositoryName");
                serializer.writeCharacters(daemon.getRepositoryName());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDependency(Dependency dependency, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependency != null) {
            serializer.writeStartElement(tagName);
            if (dependency.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(dependency.getGroupId());
                serializer.writeEndElement();
            }
            if (dependency.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(dependency.getArtifactId());
                serializer.writeEndElement();
            }
            if (dependency.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(dependency.getVersion());
                serializer.writeEndElement();
            }
            if (dependency.getClassifier() != null) {
                serializer.writeStartElement("classifier");
                serializer.writeCharacters(dependency.getClassifier());
                serializer.writeEndElement();
            }
            if (dependency.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(dependency.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDirectory(Directory directory, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (directory != null) {
            serializer.writeStartElement(tagName);
            if (directory.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(directory.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer) throws XMLStreamException {
        serializer.writeStartElement(dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.writeAttribute(attributeName, dom.getAttribute(attributeName));
        }
        Xpp3Dom[] children = dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeDom(children[i], serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeGeneratorConfiguration(GeneratorConfiguration generatorConfiguration, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (generatorConfiguration != null) {
            serializer.writeStartElement(tagName);
            if (generatorConfiguration.getGenerator() != null) {
                serializer.writeStartElement("generator");
                serializer.writeCharacters(generatorConfiguration.getGenerator());
                serializer.writeEndElement();
            }
            if (generatorConfiguration.getConfiguration() != null && ((Hashtable)generatorConfiguration.getConfiguration()).size() > 0) {
                serializer.writeStartElement("configuration");
                Iterator iter = ((Hashtable)generatorConfiguration.getConfiguration()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)generatorConfiguration.getConfiguration()).get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJvmSettings(JvmSettings jvmSettings, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jvmSettings != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (jvmSettings.getInitialMemorySize() != null) {
                serializer.writeStartElement("initialMemorySize");
                serializer.writeCharacters(jvmSettings.getInitialMemorySize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getMaxMemorySize() != null) {
                serializer.writeStartElement("maxMemorySize");
                serializer.writeCharacters(jvmSettings.getMaxMemorySize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getMaxStackSize() != null) {
                serializer.writeStartElement("maxStackSize");
                serializer.writeCharacters(jvmSettings.getMaxStackSize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getSystemProperties() != null && jvmSettings.getSystemProperties().size() > 0) {
                serializer.writeStartElement("systemProperties");
                iter = jvmSettings.getSystemProperties().iterator();
                while (iter.hasNext()) {
                    String systemProperty = (String)iter.next();
                    serializer.writeStartElement("systemProperty");
                    serializer.writeCharacters(systemProperty);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (jvmSettings.getExtraArguments() != null && jvmSettings.getExtraArguments().size() > 0) {
                serializer.writeStartElement("extraArguments");
                iter = jvmSettings.getExtraArguments().iterator();
                while (iter.hasNext()) {
                    String extraArgument = (String)iter.next();
                    serializer.writeStartElement("extraArgument");
                    serializer.writeCharacters(extraArgument);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

