/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.latex;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LaTeXMojo
extends AbstractMojo {
    private File docsRoot;
    private String commonsDirName;
    private File buildDir;
    private File latexBuildDir;
    private String binariesPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File[] docDirs = this.getDocDirs();
            File[] buildDirs = this.prepareLaTeXBuildDirectories(docDirs);
            this.buildDocuments(buildDirs);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void buildDocuments(File[] buildDirs) throws IOException, MojoFailureException {
        for (File dir : buildDirs) {
            File texFile = new File(dir, dir.getName() + ".tex");
            File pdfFile = new File(dir, dir.getName() + ".pdf");
            File bibFile = new File(dir, dir.getName() + ".bib");
            CommandLine pdfLaTeX = CommandLine.parse((String)this.executablePath("pdflatex")).addArgument("--halt-on-error").addArgument(texFile.getAbsolutePath());
            CommandLine bibTeX = CommandLine.parse((String)this.executablePath("bibtex")).addArgument(dir.getName());
            this.execute(pdfLaTeX, dir);
            if (bibFile.exists()) {
                this.execute(bibTeX, dir);
                this.execute(pdfLaTeX, dir);
            }
            this.execute(pdfLaTeX, dir);
            FileUtils.copyFile((File)pdfFile, (File)new File(this.buildDir, pdfFile.getName()));
        }
    }

    private String executablePath(String executable) {
        if (this.binariesPath == null) {
            return executable;
        }
        return this.binariesPath + File.separator + executable;
    }

    private void execute(CommandLine commandLine, File dir) throws IOException, MojoFailureException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(dir);
        if (executor.execute(commandLine) != 0) {
            throw new MojoFailureException("Error code returned for: " + commandLine.toString());
        }
    }

    private File[] prepareLaTeXBuildDirectories(File[] docDirs) throws IOException {
        File[] buildDirs = new File[docDirs.length];
        File commonsDir = new File(this.docsRoot, this.commonsDirName);
        for (int i = 0; i < docDirs.length; ++i) {
            File target;
            File dir = docDirs[i];
            buildDirs[i] = target = new File(this.latexBuildDir, docDirs[i].getName());
            FileUtils.copyDirectory((File)dir, (File)target);
            if (!commonsDir.exists()) continue;
            FileUtils.copyDirectory((File)commonsDir, (File)target);
        }
        return buildDirs;
    }

    private File[] getDocDirs() {
        return this.docsRoot.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(LaTeXMojo.this.commonsDirName) && !pathname.isHidden();
            }
        });
    }
}

