/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.Collection;
import java.util.Locale;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicenseReportRenderer
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;

    public AbstractLicenseReportRenderer(Sink sink, String bundleName, I18N i18n, Locale locale) {
        super(sink);
        this.bundleName = bundleName;
        this.i18n = i18n;
        this.locale = locale;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    protected void renderErrorIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    protected void renderSuccessIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_success_sml.gif");
        this.sink.figure_();
    }

    protected void renderInfoIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    protected String getGAV(ThirdPartyDetails details) {
        return ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId()) + ":" + details.getVersion();
    }

    protected void renderThirdPartySummaryTableHeader() {
        this.renderThirdPartySummaryTableHeader(true, true, true);
    }

    protected void renderThirdPartySummaryTableHeader(boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.status"));
        this.sinkHeaderCellText(this.getText("report.gav"));
        if (includeScope) {
            this.sinkHeaderCellText(this.getText("report.scope"));
        }
        if (includeClassifier) {
            this.sinkHeaderCellText(this.getText("report.classifier"));
        }
        if (includeType) {
            this.sinkHeaderCellText(this.getText("report.type"));
        }
        this.sinkHeaderCellText(this.getText("report.licenses"));
        this.sink.tableRow_();
    }

    protected void renderThirdPartySummaryTableRow(ThirdPartyDetails details) {
        this.renderThirdPartySummaryTableRow(details, true, true, true);
    }

    protected void sinkHeaderCellText(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkHeaderCellText(String width, String text) {
        this.sink.tableHeaderCell(width);
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkCellText(String width, String text) {
        this.sink.tableCell(width);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellText(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void renderThirdPartySummaryTableRow(ThirdPartyDetails details, boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (details.hasPomLicenses()) {
            this.renderSuccessIcon();
        } else if (details.hasThirdPartyLicenses()) {
            this.renderWarningIcon();
        } else {
            this.renderErrorIcon();
        }
        this.sink.tableCell();
        String gav = this.getGAV(details);
        this.sink.link("./third-party-report.html#" + gav);
        this.sink.text(gav);
        this.sink.link_();
        this.sink.tableCell_();
        if (includeScope) {
            this.sinkCellText(details.getScope());
        }
        if (includeClassifier) {
            this.sinkCellText(details.getClassifier());
        }
        if (includeType) {
            this.sinkCellText(details.getType());
        }
        this.sink.tableCell();
        if (details.hasLicenses()) {
            String[] licenses = details.getLicenses();
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
        } else {
            this.sink.text("-");
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void safeBold() {
        try {
            this.sink.bold();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeBold_() {
        try {
            this.sink.bold_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic() {
        try {
            this.sink.italic();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void safeItalic_() {
        try {
            this.sink.italic_();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    protected void renderThirdPartyDetailTable(ThirdPartyDetails details) {
        this.renderThirdPartyDetailTable(details, true, true, true);
    }

    protected void renderThirdPartyDetailTable(ThirdPartyDetails details, boolean includeScope, boolean includeClassifier, boolean includeType) {
        String cellWidth = "80%";
        String headerWidth = "20%";
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.status"));
        this.sink.tableCell("80%");
        if (details.hasPomLicenses()) {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.licenseFromPom"));
        } else if (details.hasThirdPartyLicenses()) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.licenseFromThirdParty"));
        } else {
            this.renderErrorIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.noLicense"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.gav"));
        this.sinkCellText("80%", this.getGAV(details));
        this.sink.tableRow_();
        if (includeScope) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.scope"));
            this.sinkCellText("80%", details.getScope());
            this.sink.tableRow_();
        }
        if (includeClassifier) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.classifier"));
            this.sinkCellText("80%", details.getClassifier());
            this.sink.tableRow_();
        }
        if (includeType) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.type"));
            this.sinkCellText("80%", details.getType());
            this.sink.tableRow_();
        }
        String[] licenses = details.getLicenses();
        if (details.hasPomLicenses()) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sink.tableCell("80%");
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        } else if (details.hasThirdPartyLicenses()) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sink.tableCell("80%");
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        } else {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sinkCellText("80%", this.getText("report.no.license"));
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void renderThirdPartySummaryTable(Collection<ThirdPartyDetails> collection) {
        this.renderThirdPartySummaryTable(collection, true, true, true);
    }

    protected void renderThirdPartySummaryTable(Collection<ThirdPartyDetails> collection, boolean includeScope, boolean includeClassifier, boolean includeType) {
        this.sink.table();
        this.renderThirdPartySummaryTableHeader(includeScope, includeClassifier, includeType);
        for (ThirdPartyDetails details : collection) {
            this.renderThirdPartySummaryTableRow(details, includeScope, includeClassifier, includeType);
        }
        this.renderThirdPartySummaryTableHeader(includeScope, includeClassifier, includeType);
        this.sink.table_();
    }

    protected void renderPropertySummaryTableHeader() {
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.status"));
        this.sinkHeaderCellText(this.getText("report.property"));
        this.sinkHeaderCellText(this.getText("report.currentVersion"));
        this.sinkHeaderCellText(this.getText("report.nextVersion"));
        this.sinkHeaderCellText(this.getText("report.nextIncremental"));
        this.sinkHeaderCellText(this.getText("report.nextMinor"));
        this.sinkHeaderCellText(this.getText("report.nextMajor"));
        this.sink.tableRow_();
    }
}

