/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.license.AbstractLicenseReportMojo;
import org.codehaus.mojo.license.ThirdPartyReportRenderer;
import org.codehaus.mojo.license.api.DefaultThirdPartyDetails;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.MojoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyReportMojo
extends AbstractLicenseReportMojo
implements MavenProjectDependenciesConfigurator {
    private String excludedScopes;
    private String includedScopes;
    private String excludedGroups;
    private String includedGroups;
    private String excludedArtifacts;
    private String includedArtifacts;
    private boolean includeTransitiveDependencies;
    private boolean useMissingFile;
    private File missingFile;
    private boolean useRepositoryMissingFiles;
    private List<String> licenseMerges;

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException, MojoExecutionException, MojoFailureException {
        Collection<ThirdPartyDetails> details;
        try {
            details = this.createThirdPartyDetails();
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ThirdPartyToolException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        ThirdPartyReportRenderer renderer = new ThirdPartyReportRenderer(sink, this.getI18n(), this.getOutputName(), locale, details);
        renderer.render();
    }

    public String getOutputName() {
        return "third-party-report";
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    protected Collection<ThirdPartyDetails> createThirdPartyDetails() throws IOException, ThirdPartyToolException, ProjectBuildingException, MojoFailureException {
        SortedMap<String, MavenProject> projectDependencies = this.getHelper().loadDependencies(this);
        LicenseMap licenseMap = this.getHelper().createLicenseMap(projectDependencies);
        SortedSet<MavenProject> dependenciesWithNoLicense = this.getHelper().getProjectsWithNoLicense(licenseMap);
        TreeSet<MavenProject> dependenciesWithPomLicense = new TreeSet<MavenProject>(MojoHelper.newMavenProjectComparator());
        dependenciesWithPomLicense.addAll(projectDependencies.values());
        if (CollectionUtils.isNotEmpty(dependenciesWithNoLicense)) {
            dependenciesWithPomLicense.removeAll(dependenciesWithNoLicense);
            if (this.useMissingFile) {
                this.getHelper().createUnsafeMapping(licenseMap, this.missingFile, this.useRepositoryMissingFiles, dependenciesWithNoLicense, projectDependencies.values());
            }
        }
        this.getHelper().mergeLicenses(this.licenseMerges, licenseMap);
        ArrayList<ThirdPartyDetails> details = new ArrayList<ThirdPartyDetails>();
        for (Map.Entry<MavenProject, String[]> entry : licenseMap.toDependencyMap().entrySet()) {
            MavenProject dependency = entry.getKey();
            String[] licenses = entry.getValue();
            DefaultThirdPartyDetails detail = new DefaultThirdPartyDetails(dependency);
            details.add(detail);
            if (dependenciesWithPomLicense.contains(dependency)) {
                detail.setPomLicenses(licenses);
                continue;
            }
            if (dependenciesWithNoLicense.contains(dependency)) continue;
            detail.setThirdPartyLicenses(licenses);
        }
        return details;
    }
}

