/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderProcessor;
import org.codehaus.mojo.license.header.FileHeaderProcessorConfiguration;
import org.codehaus.mojo.license.header.InvalideFileHeaderException;
import org.codehaus.mojo.license.header.UpdateFileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateFileHeaderMojo
extends AbstractLicenseNameMojo
implements FileHeaderProcessorConfiguration {
    protected String projectName;
    protected String organizationName;
    protected String inceptionYear;
    protected String processStartTag;
    protected String processEndTag;
    protected String sectionDelimiter;
    protected boolean addSvnKeyWords;
    protected boolean canUpdateDescription;
    protected boolean canUpdateCopyright;
    protected boolean canUpdateLicense;
    protected boolean updateCopyright;
    protected String ignoreTag;
    protected boolean skipUpdateLicense;
    protected boolean dryRun;
    protected boolean clearAfterOperation;
    protected String[] roots;
    protected String[] includes;
    protected String[] excludes;
    protected Map<String, String> extraExtensions;
    protected String descriptionTemplate;
    private FileHeaderProcessor processor;
    private UpdateFileHeaderFilter filter;
    private Map<String, FileHeaderTransformer> transformers;
    private FileHeaderTransformer transformer;
    private FreeMarkerHelper freeMarkerHelper;
    private FileHeader header;
    private long timestamp;
    private Map<String, String> extensionToCommentStyle;
    private Template descriptionTemplate0;
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    public static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.zargo", "**/*.uml", "**/*.umldi", "**/*.xmi", "**/*.img", "**/*.png", "**/*.jpg", "**/*.jpeg", "**/*.gif", "**/*.zip", "**/*.jar", "**/*.war", "**/*.ear", "**/*.tgz", "**/*.gz"};
    public static final String[] DEFAULT_ROOTS = new String[]{"src", "target/generated-sources", "target/processed-sources"};
    private Set<File> processedFiles;
    private EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreateByCommentStyle;

    @Override
    public void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.ignoreTag)) {
            this.ignoreTag = "%%Ignore-License";
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String string = "\n  * %1$s (%2$s)";
            for (String transformerName : this.transformers.keySet()) {
                FileHeaderTransformer aTransformer = this.getTransformer(transformerName);
                String str = String.format(string, aTransformer.getName(), aTransformer.getDescription());
                buffer.append(str);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.updateCopyright) {
            this.getLog().warn((CharSequence)"\n\nupdateCopyright is not still available...\n\n");
        }
        this.timestamp = System.nanoTime();
        this.filter.setUpdateCopyright(this.canUpdateCopyright);
        this.filter.setUpdateDescription(this.canUpdateDescription);
        this.filter.setUpdateLicense(this.canUpdateLicense);
        this.filter.setLog(this.getLog());
        this.processor.setConfiguration(this);
        this.processor.setFilter(this.filter);
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default roots " + Arrays.toString(this.roots)));
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default includes " + Arrays.toString(this.includes)));
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default excludes" + Arrays.toString(this.excludes)));
            }
        }
        this.extensionToCommentStyle = new TreeMap<String, String>();
        this.processStartTag = this.cleanHeaderConfiguration(this.processStartTag, "#%L");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use processStartTag: " + this.processEndTag));
        }
        this.processEndTag = this.cleanHeaderConfiguration(this.processEndTag, "#L%");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use processEndTag: " + this.processEndTag));
        }
        this.sectionDelimiter = this.cleanHeaderConfiguration(this.sectionDelimiter, "%%");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use sectionDelimiter: " + this.sectionDelimiter));
        }
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            FileHeaderTransformer aTransformer = entry.getValue();
            aTransformer.setProcessStartTag(this.processStartTag);
            aTransformer.setProcessEndTag(this.processEndTag);
            aTransformer.setSectionDelimiter(this.sectionDelimiter);
            for (String extension : extensions = aTransformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension " + extension + " to comment style " + commentStyle));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (this.extensionToCommentStyle.containsKey(extension)) {
                    this.getLog().warn((CharSequence)("The extension " + extension + " is already accepted for comment style " + this.extensionToCommentStyle.get(extension)));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(commentStyle);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension '" + extension + "' to comment style '" + commentStyle + "'"));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        this.filesToTreateByCommentStyle = this.obtainFilesToTreateByCommentStyle();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use description template : " + this.descriptionTemplate));
        }
        this.descriptionTemplate0 = this.freeMarkerHelper.getTemplate(this.descriptionTemplate);
    }

    protected Map<String, List<File>> obtainFilesToTreateByCommentStyle() {
        HashMap<String, List<File>> results = new HashMap<String, List<File>>();
        for (String commentStyle : this.transformers.keySet()) {
            results.put(commentStyle, new ArrayList());
        }
        ArrayList<String> rootsList = new ArrayList<String>(this.roots.length);
        for (String string : this.roots) {
            File f = new File(string);
            if (f.isAbsolute()) {
                rootsList.add(f.getAbsolutePath());
            } else {
                f = new File(this.getProject().getBasedir(), string);
            }
            if (f.exists()) {
                this.getLog().info((CharSequence)("Will search files to update from root " + f));
                rootsList.add(f.getAbsolutePath());
                continue;
            }
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("Skip not found root " + f));
        }
        HashMap<File, String[]> allFiles = new HashMap<File, String[]>();
        this.getFilesToTreateForRoots(this.includes, this.excludes, rootsList, allFiles);
        for (Map.Entry entry : allFiles.entrySet()) {
            String[] filesPath;
            File file = (File)entry.getKey();
            for (String path : filesPath = (String[])entry.getValue()) {
                String extension = FileUtils.extension((String)path);
                String commentStyle = this.extensionToCommentStyle.get(extension);
                if (StringUtils.isEmpty((String)commentStyle)) continue;
                File file2 = new File(file, path);
                List files = (List)results.get(commentStyle);
                files.add(file2);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        block14: {
            int nbFiles2;
            long t0;
            block13: {
                t0 = System.nanoTime();
                this.clear();
                this.processedFiles = new HashSet<File>();
                this.result = new EnumMap(FileState.class);
                try {
                    for (Map.Entry<String, List<File>> commentStyleFiles : this.filesToTreateByCommentStyle.entrySet()) {
                        String commentStyle = commentStyleFiles.getKey();
                        List<File> files = commentStyleFiles.getValue();
                        this.processCommentStyle(commentStyle, files);
                    }
                    Object var8_6 = null;
                    nbFiles2 = this.processedFiles.size();
                    if (nbFiles2 != 0) break block13;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    int nbFiles2 = this.processedFiles.size();
                    if (nbFiles2 == 0) {
                        this.getLog().warn((CharSequence)"No file to scan.");
                    } else {
                        String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                        String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
                        this.getLog().info((CharSequence)message);
                    }
                    Set<FileState> states = this.result.keySet();
                    if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                        this.getLog().info((CharSequence)"All files are up-to-date.");
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        for (FileState state : FileState.values()) {
                            this.reportType(state, buffer);
                        }
                        this.getLog().info((CharSequence)buffer.toString());
                    }
                    if (this.clearAfterOperation) {
                        this.clear();
                    }
                    throw throwable;
                }
                this.getLog().warn((CharSequence)"No file to scan.");
                break block14;
            }
            String delay = MojoHelper.convertTime(System.nanoTime() - t0);
            String message = String.format("Scan %s file%s header done in %s.", nbFiles2, nbFiles2 > 1 ? "s" : "", delay);
            this.getLog().info((CharSequence)message);
        }
        Set<FileState> states = this.result.keySet();
        if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
            this.getLog().info((CharSequence)"All files are up-to-date.");
        } else {
            StringBuilder buffer = new StringBuilder();
            for (FileState state : FileState.values()) {
                this.reportType(state, buffer);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.clearAfterOperation) {
            this.clear();
        }
    }

    protected void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        this.getLog().info((CharSequence)("Process header '" + commentStyle + "'"));
        this.getLog().info((CharSequence)(" - using " + license.getDescription()));
        this.transformer = this.getTransformer(commentStyle);
        this.header = this.buildDefaultFileHeader(license, this.getEncoding());
        this.processor.populateFilter();
        for (File file : filesToTreat) {
            this.prepareProcessFile(file);
        }
        filesToTreat.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prepareProcessFile(File file) throws IOException {
        if (this.processedFiles.contains(file)) {
            this.getLog().info((CharSequence)(" - skip already processed file " + file));
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        boolean doFinalize = false;
        try {
            try {
                doFinalize = this.processFile(file, processFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("skip failed file : " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage())), (Throwable)e);
                FileState.fail.addFile(file, this.result);
                doFinalize = false;
                Object var6_5 = null;
                this.processor.reset();
                this.processedFiles.add(file);
                if (doFinalize) {
                    this.finalizeFile(file, processFile);
                    return;
                }
                FileUtil.deleteFile(processFile);
                return;
            }
            Object var6_4 = null;
            this.processor.reset();
            this.processedFiles.add(file);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.processor.reset();
            this.processedFiles.add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
                throw throwable;
            }
            FileUtil.deleteFile(processFile);
            throw throwable;
        }
        if (doFinalize) {
            this.finalizeFile(file, processFile);
            return;
        }
        FileUtil.deleteFile(processFile);
    }

    protected boolean processFile(File file, File processFile) throws IOException {
        String content;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(" - process file " + file));
            this.getLog().debug((CharSequence)(" - will process into file " + processFile));
        }
        this.updateFileHeaderDescription(file);
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.ignoreTag)) {
            this.getLog().info((CharSequence)(" - ignore file (detected " + this.ignoreTag + ") " + file));
            FileState.ignore.addFile(file, this.result);
            return false;
        }
        try {
            this.processor.process(file, processFile);
        }
        catch (IllegalStateException e) {
            throw new InvalideFileHeaderException("Could not extract header on file " + file + " for reason " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof InvalideFileHeaderException) {
                throw (InvalideFileHeaderException)e;
            }
            throw new IOException("Could not process file " + file + " for reason " + e.getMessage());
        }
        if (this.processor.isTouched()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)(" - header was updated for " + file));
            }
            if (this.processor.isModified()) {
                FileState.update.addFile(file, this.result);
                return true;
            }
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        if (this.processor.isDetectHeader()) {
            throw new InvalideFileHeaderException("Could not find header end on file " + file);
        }
        this.getLog().info((CharSequence)(" - adding license header on file " + file));
        content = this.getTransformer().addHeader(this.filter.getFullHeaderContent(), content);
        if (!this.dryRun) {
            FileUtil.writeString(processFile, content, this.getEncoding());
        }
        FileState.add.addFile(file, this.result);
        return true;
    }

    protected void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.dryRun) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)(" - backup original file " + file));
            }
            FileUtil.renameFile(file, backupFile);
        }
        if (this.dryRun) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                FileUtil.renameFile(processFile, file);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
                FileUtils.copyFile((File)processFile, (File)file);
                FileUtil.deleteFile(processFile);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    protected void clear() {
        if (this.processedFiles != null) {
            this.processedFiles.clear();
        }
        if (this.result != null) {
            for (Set<File> fileSet : this.result.values()) {
                fileSet.clear();
            }
            this.result.clear();
        }
    }

    protected void reportType(FileState state, StringBuilder buffer) {
        String operation = state.name();
        Set<File> set = this.getFiles(state);
        if (set == null || set.isEmpty()) {
            if (this.isVerbose()) {
                buffer.append("\n * no header to ");
                buffer.append(operation);
                buffer.append(".");
            }
            return;
        }
        buffer.append("\n * ").append(operation).append(" header on ");
        buffer.append(set.size());
        if (set.size() == 1) {
            buffer.append(" file.");
        } else {
            buffer.append(" files.");
        }
        if (this.isVerbose()) {
            for (File file : set) {
                buffer.append("\n   - ").append(file);
            }
        }
    }

    protected FileHeader buildDefaultFileHeader(License license, String encoding) throws IOException {
        FileHeader defaultFileHeader = new FileHeader();
        String licenseContent = license.getHeaderContent(encoding);
        defaultFileHeader.setLicense(licenseContent);
        Integer firstYear = Integer.valueOf(this.inceptionYear);
        defaultFileHeader.setCopyrightFirstYear(firstYear);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        if (firstYear < lastYear) {
            defaultFileHeader.setCopyrightLastYear(lastYear);
        }
        defaultFileHeader.setCopyrightHolder(this.organizationName);
        return defaultFileHeader;
    }

    protected void updateFileHeaderDescription(File file) throws IOException {
        HashMap<String, Object> descriptionParameters = new HashMap<String, Object>();
        descriptionParameters.put("project", this.getProject());
        descriptionParameters.put("addSvnKeyWords", this.addSvnKeyWords);
        descriptionParameters.put("projectName", this.projectName);
        descriptionParameters.put("inceptionYear", this.inceptionYear);
        descriptionParameters.put("organizationName", this.organizationName);
        descriptionParameters.put("file", file);
        String description = this.freeMarkerHelper.renderTemplate(this.descriptionTemplate0, descriptionParameters);
        this.header.setDescription(description);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("header description : " + this.header.getDescription()));
        }
    }

    public FileHeaderTransformer getTransformer(String transformerName) {
        if (StringUtils.isEmpty((String)transformerName)) {
            throw new IllegalArgumentException("transformerName can not be null, nor empty!");
        }
        if (this.transformers == null) {
            throw new IllegalStateException("No transformers initialized!");
        }
        FileHeaderTransformer transformer = this.transformers.get(transformerName);
        if (transformer == null) {
            throw new IllegalArgumentException("transformerName " + transformerName + " is unknow, use one this one : " + this.transformers.keySet());
        }
        return transformer;
    }

    protected String cleanHeaderConfiguration(String value, String defaultValue) {
        String resultHeader = StringUtils.isEmpty((String)value) ? defaultValue : value.replaceAll("\\s", "");
        return resultHeader;
    }

    @Override
    public FileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public FileHeaderTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isSkip() {
        return this.skipUpdateLicense;
    }

    public Set<File> getFiles(FileState state) {
        return this.result.get((Object)state);
    }

    @Override
    public void setSkip(boolean skip) {
        this.skipUpdateLicense = skip;
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("discovering source files in " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList toTreate = new ArrayList();
            Collections.addAll(toTreate, tmp);
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileState {
        update,
        uptodate,
        add,
        ignore,
        fail;


        public void addFile(File file, EnumMap<FileState, Set<File>> results) {
            Set<File> fileSet = results.get((Object)this);
            if (fileSet == null) {
                fileSet = new HashSet<File>();
                results.put(this, fileSet);
            }
            fileSet.add(file);
        }
    }
}

