/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rmic.BuiltInRmiCompiler;
import org.codehaus.mojo.rmic.RmiCompiler;
import org.codehaus.mojo.rmic.RmiCompilerConfiguration;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.mojo.rmic.Source;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRmiMojo
extends AbstractMojo {
    private static final String STUB_CLASS_PATTERN = "**/*_Stub.class";
    private Source source;
    @Parameter
    private List<Source> sources;
    @Parameter
    protected Set<String> includes;
    @Parameter
    protected Set<String> excludes;
    @Parameter(defaultValue="sun")
    protected String compiler;
    private RmiCompiler rmiCompiler = new BuiltInRmiCompiler();
    @Parameter
    private String version;
    @Parameter(defaultValue="false")
    private boolean iiop;
    @Parameter(defaultValue="false")
    private boolean noLocalStubs;
    @Parameter(defaultValue="false")
    private boolean idl;
    @Parameter(defaultValue="false")
    private boolean noValueMethods;
    @Parameter(defaultValue="false")
    private boolean keep;
    @Parameter(defaultValue="false")
    private boolean nowarn;
    @Parameter(defaultValue="false")
    private boolean poa;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="0")
    private int staleMillis;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    private DependenciesFacade dependencies = new DependenciesFacadeImpl();
    private static final DependenciesFacade DEPENDENCIES_FACADE = new DependenciesFacadeImpl();

    AbstractRmiMojo() {
        this(DEPENDENCIES_FACADE);
    }

    AbstractRmiMojo(DependenciesFacade dependencies) {
        this.dependencies = dependencies;
    }

    List<Source> getSources() {
        return this.sources;
    }

    public abstract List<String> getProjectClasspathElements();

    public abstract File getOutputDirectory();

    public abstract File getClassesDirectory();

    public void execute() throws MojoExecutionException {
        if (this.sources != null && this.source != null && this.source.getConfiguredOptions().length() > 0) {
            throw new MojoExecutionException("May not use <source> elements in addition to switches without a <source> element: " + this.source.getConfiguredOptions());
        }
        if (this.sources == null || this.sources.isEmpty()) {
            this.sources = Collections.singletonList(this.getSource());
        }
        for (Source source : this.sources) {
            this.doExecute(source);
        }
    }

    private void doExecute(Source source) throws MojoExecutionException {
        this.rmiCompiler.setLog(this.getLog());
        if (source.isVerbose()) {
            this.getLog().debug((CharSequence)source.toString());
        }
        if (!this.getOutputDirectory().isDirectory() && !this.getOutputDirectory().mkdirs()) {
            throw new MojoExecutionException("Could not make output directory: '" + this.getOutputDirectory().getAbsolutePath() + "'.");
        }
        try {
            Set<File> remoteClassesToCompile = this.getRemoteClasses(source);
            if (remoteClassesToCompile.size() == 0) {
                this.getLog().info((CharSequence)"No out of date rmi classes to process.");
                return;
            }
            this.getLog().info((CharSequence)("Compiling " + remoteClassesToCompile.size() + " remote classes"));
            RmiCompilerConfiguration config = new RmiCompilerConfiguration();
            config.setClasspathEntries(this.getRmicClasspathElements());
            config.addSourceLocation(this.getClassesDirectory().getPath());
            config.setSourceFiles(remoteClassesToCompile);
            config.setIdl(source.isIdl());
            config.setIiop(source.isIiop());
            config.setKeep(source.isKeep());
            config.setNoLocalStubs(source.isNoLocalStubs());
            config.setNoValueMethods(source.isNoValueMethods());
            config.setNowarn(source.isNowarn());
            config.setOutputLocation(this.getOutputDirectory().getAbsolutePath());
            config.setPoa(source.isPoa());
            config.setVerbose(source.isVerbose());
            config.setVersion(source.getVersion());
            this.rmiCompiler.execute(config);
        }
        catch (RmiCompilerException e) {
            throw new MojoExecutionException("Error while executing the RMI compiler.", (Exception)e);
        }
    }

    private List<String> getRmicClasspathElements() {
        List<String> classpathElements = this.getProjectClasspathElements();
        if (!classpathElements.contains(this.getClassesDirectory().getAbsolutePath())) {
            classpathElements.add(this.getClassesDirectory().getAbsolutePath());
        }
        return classpathElements;
    }

    private Set<File> getRemoteClasses(Source source) {
        HashSet<File> remoteClasses = new HashSet<File>();
        try {
            List<URL> classpathList = this.generateUrlCompileClasspath();
            URL[] classpathUrls = new URL[classpathList.size()];
            classpathUrls[0] = this.getClassesDirectory().toURI().toURL();
            classpathUrls = classpathList.toArray(classpathUrls);
            this.dependencies.defineUrlClassLoader(classpathUrls);
            SourceInclusionScanner scanner = this.createScanner(source.getIncludes(), this.getExcludes(source));
            scanner.addSourceMapping((SourceMapping)new SuffixMapping(".class", "_Stub.class"));
            Set staleRemoteClasses = scanner.getIncludedSources(this.getClassesDirectory(), this.getOutputDirectory());
            for (File file : staleRemoteClasses) {
                URI relativeURI = this.getClassesDirectory().toURI().relativize(file.toURI());
                String className = AbstractRmiMojo.fileToClassName(relativeURI.toString());
                Class<?> candidateClass = this.dependencies.loadClass(className);
                if (!this.isRemoteRmiClass(candidateClass, source.isIiop())) continue;
                remoteClasses.add(new File(relativeURI.toString()));
            }
            for (String include : source.getIncludes()) {
                File includeFile = new File(this.getClassesDirectory(), include);
                if (include.contains("*") || this.dependencies.fileExists(includeFile)) continue;
                remoteClasses.add(includeFile);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Problem while scanning for classes: " + e));
        }
        return remoteClasses;
    }

    private SourceInclusionScanner createScanner(Set<String> includes, Set<String> excludes) {
        return this.dependencies.createScanner(this.staleMillis, includes, excludes);
    }

    private Set<String> getExcludes(Source source) {
        Set<String> excludes = source.getExcludes();
        excludes.add(STUB_CLASS_PATTERN);
        return excludes;
    }

    private static String fileToClassName(String classFileName) {
        return StringUtils.replace((String)StringUtils.replace((String)classFileName, (String)".class", (String)""), (String)"/", (String)".");
    }

    private boolean isRemoteRmiClass(Class<?> remoteClass, boolean isIiop) {
        return Remote.class.isAssignableFrom(remoteClass) && (!remoteClass.isInterface() || isIiop);
    }

    private List<URL> generateUrlCompileClasspath() throws MojoExecutionException {
        ArrayList<URL> rmiCompileClasspath = new ArrayList<URL>();
        try {
            rmiCompileClasspath.add(this.getClassesDirectory().toURI().toURL());
            for (String classpathElement : this.getRmicClasspathElements()) {
                URL pathUrl = new File(classpathElement).toURI().toURL();
                rmiCompileClasspath.add(pathUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Problem while generating classpath: " + e.getMessage());
        }
        return rmiCompileClasspath;
    }

    private Source getSource() {
        if (this.source == null) {
            this.source = new Source();
        }
        return this.source;
    }

    public void setIncludes(Set<String> includes) {
        this.getSource().setIncludes(includes);
    }

    public void setExcludes(Set<String> excludes) {
        this.getSource().setExcludes(excludes);
    }

    public void setVersion(String version) {
        this.getSource().setVersion(version);
    }

    public void setIiop(Boolean iiop) {
        this.getSource().setIiop(iiop);
    }

    public void setNoLocalStubs(Boolean noLocalStubs) {
        this.getSource().setNoLocalStubs(noLocalStubs);
    }

    public void setIdl(Boolean idl) {
        this.getSource().setIdl(idl);
    }

    public void setNoValueMethods(Boolean noValueMethods) {
        this.getSource().setNoValueMethods(noValueMethods);
    }

    public void setKeep(Boolean keep) {
        this.getSource().setKeep(keep);
    }

    public void setNowarn(Boolean nowarn) {
        this.getSource().setNowarn(nowarn);
    }

    public void setPoa(Boolean poa) {
        this.getSource().setPoa(poa);
    }

    public void setVerbose(Boolean verbose) {
        this.getSource().setVerbose(verbose);
    }

    private static class DependenciesFacadeImpl
    implements DependenciesFacade {
        private static URLClassLoader loader;

        private DependenciesFacadeImpl() {
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            return loader.loadClass(className);
        }

        @Override
        public void defineUrlClassLoader(URL[] classpathUrls) {
            loader = new URLClassLoader(classpathUrls);
        }

        @Override
        public boolean fileExists(File includeFile) {
            return includeFile.exists();
        }

        @Override
        public SourceInclusionScanner createScanner(int staleMillis, Set<String> includes, Set<String> excludes) {
            return new StaleSourceScanner((long)staleMillis, includes, excludes);
        }
    }

    static interface DependenciesFacade {
        public boolean fileExists(File var1);

        public SourceInclusionScanner createScanner(int var1, Set<String> var2, Set<String> var3);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public void defineUrlClassLoader(URL[] var1);
    }
}

