/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.mojo.rmic.AbstractRmiCompiler;
import org.codehaus.plexus.compiler.CompilerException;

class BuiltInRmiCompiler
extends AbstractRmiCompiler {
    private static final String EOL = System.getProperty("line.separator");
    private static final String RMIC_CLASSNAME = "sun.rmi.rmic.Main";
    private static final String USE_GLASSFISH_RMIC = " Built-in RMIC compiler not available in JDK9. Add a dependency on org.glassfish.corba:rmic to the plugin.";

    BuiltInRmiCompiler() {
    }

    @Override
    protected Class<?> createMainClass() throws CompilerException {
        try {
            return BuiltInRmiCompiler.getClassLoaderFacade().loadClass(RMIC_CLASSNAME);
        }
        catch (ClassNotFoundException ignored) {
            try {
                BuiltInRmiCompiler.addToolsJarToPath();
                return BuiltInRmiCompiler.getClassLoaderFacade().loadClass(RMIC_CLASSNAME);
            }
            catch (Exception ex) {
                throw new CompilerException(BuiltInRmiCompiler.getSecondTryMessage(ex));
            }
        }
    }

    private static String getSecondTryMessage(Exception e) throws CompilerException {
        return BuiltInRmiCompiler.builtInCompilerHidden(e) ? USE_GLASSFISH_RMIC : BuiltInRmiCompiler.getRmicCompilerNotAvailableMessage();
    }

    private static boolean builtInCompilerHidden(Exception e) {
        return BuiltInRmiCompiler.compilerNotFound(e) && BuiltInRmiCompiler.isJigsawPresent();
    }

    private static boolean compilerNotFound(Exception e) {
        return e instanceof ClassNotFoundException;
    }

    private static boolean isJigsawPresent() {
        return !System.getProperty("java.version").startsWith("1.");
    }

    private static String getRmicCompilerNotAvailableMessage() throws CompilerException {
        return "Unable to locate the Rmi Compiler in:" + EOL + "  " + BuiltInRmiCompiler.getToolsJarUrl() + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the " + RMIC_CLASSNAME + " class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.";
    }

    private static void addToolsJarToPath() throws MalformedURLException, ClassNotFoundException, CompilerException {
        URL toolsJarUrl = BuiltInRmiCompiler.getToolsJarUrl();
        BuiltInRmiCompiler.getClassLoaderFacade().prependUrls(toolsJarUrl);
    }

    private static URL getToolsJarUrl() throws CompilerException {
        File javaHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        try {
            return toolsJar.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CompilerException("Could not convert the file reference to tools.jar to a URL path to the jar: '" + toolsJar.getAbsolutePath() + "'.", (Throwable)e);
        }
    }
}

