/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.gleaner;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerException;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerSupport;
import org.codehaus.plexus.metadata.gleaner.SourceComponentGleaner;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.util.StringUtils;

public class QDoxComponentGleaner
extends ComponentGleanerSupport
implements SourceComponentGleaner {
    public static final String PLEXUS_COMPONENT_TAG = "plexus.component";
    public static final String PLEXUS_REQUIREMENT_TAG = "plexus.requirement";
    public static final String PLEXUS_CONFIGURATION_TAG = "plexus.configuration";
    public static final String PLEXUS_VERSION_PARAMETER = "version";
    public static final String PLEXUS_ROLE_PARAMETER = "role";
    public static final String PLEXUS_ROLE_HINT_PARAMETER = "role-hint";
    public static final String PLEXUS_ROLE_HINT_LIST_PARAMETER = "role-hints";
    public static final String PLEXUS_ALIAS_PARAMETER = "alias";
    public static final String PLEXUS_DEFAULT_VALUE_PARAMETER = "default-value";
    public static final String PLEXUS_LIFECYCLE_HANDLER_PARAMETER = "lifecycle-handler";
    public static final String PLEXUS_INSTANTIATION_STARTEGY_PARAMETER = "instantiation-strategy";
    public static final String PLEXUS_OPTIONAL_PARAMETER = "optional";
    public static final String PLEXUS_DEFAULT_HINT = "default";
    private static final List<String> IGNORED_INTERFACES = Collections.unmodifiableList(Arrays.asList(LogEnabled.class.getName(), Initializable.class.getName(), Configurable.class.getName(), Contextualizable.class.getName(), Disposable.class.getName(), Startable.class.getName()));

    @Override
    public ComponentDescriptor<?> glean(JavaProjectBuilder classCache, JavaClass javaClass) throws ComponentGleanerException {
        int i;
        DocletTag tag = javaClass.getTagByName(PLEXUS_COMPONENT_TAG);
        if (tag == null) {
            return null;
        }
        Map parameters = tag.getNamedParameterMap();
        String fqn = javaClass.getFullyQualifiedName();
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setImplementation(fqn);
        String role = this.getParameter(parameters, PLEXUS_ROLE_PARAMETER);
        if (role == null && (role = this.findRole(javaClass)) == null) {
            return null;
        }
        componentDescriptor.setRole(role);
        String roleHint = this.getParameter(parameters, PLEXUS_ROLE_HINT_PARAMETER);
        if (roleHint != null) {
            // empty if block
        }
        componentDescriptor.setRoleHint(roleHint);
        String version = this.getParameter(parameters, PLEXUS_VERSION_PARAMETER);
        componentDescriptor.setVersion(version);
        String lifecycleHandler = this.getParameter(parameters, PLEXUS_LIFECYCLE_HANDLER_PARAMETER);
        componentDescriptor.setLifecycleHandler(lifecycleHandler);
        String instatiationStrategy = this.getParameter(parameters, PLEXUS_INSTANTIATION_STARTEGY_PARAMETER);
        componentDescriptor.setInstantiationStrategy(instatiationStrategy);
        componentDescriptor.setAlias(this.getParameter(parameters, PLEXUS_ALIAS_PARAMETER));
        this.findExtraParameters(PLEXUS_COMPONENT_TAG, parameters);
        this.findRequirements(classCache, componentDescriptor, javaClass);
        String comment = javaClass.getComment();
        if (comment != null && (i = comment.indexOf(46)) > 0) {
            comment = comment.substring(0, i + 1);
        }
        componentDescriptor.setDescription(comment);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration("configuration");
        this.findConfiguration(configuration, javaClass);
        componentDescriptor.setConfiguration((PlexusConfiguration)configuration);
        return componentDescriptor;
    }

    private static String getPackage(JavaClass javaClass) {
        if (javaClass.getPackage() != null) {
            return javaClass.getPackage().getName();
        }
        return "";
    }

    private String findRole(JavaClass javaClass) {
        JavaClass superClass;
        ArrayList interfaces = new ArrayList(javaClass.getInterfaces());
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            JavaClass ifc = (JavaClass)it.next();
            if (!IGNORED_INTERFACES.contains(ifc.getFullyQualifiedName())) continue;
            it.remove();
        }
        String role = null;
        String className = javaClass.getName();
        for (JavaClass ifc : interfaces) {
            String name;
            String fqn = ifc.getFullyQualifiedName();
            String pkg = QDoxComponentGleaner.getPackage(ifc);
            if (pkg == null) {
                int index = fqn.lastIndexOf(46);
                if (index == -1) {
                    pkg = QDoxComponentGleaner.getPackage(javaClass);
                    fqn = pkg + "." + fqn;
                } else {
                    pkg = fqn.substring(0, index);
                }
            }
            if (fqn == null) {
                fqn = ifc.getName();
            }
            if (!className.endsWith(name = fqn.substring(pkg.length() + 1))) continue;
            if (role != null) {
                // empty if block
            }
            role = fqn;
        }
        if (role == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            role = this.findRole(superClass);
        }
        return role;
    }

    private void findRequirements(JavaProjectBuilder classCache, ComponentDescriptor<?> componentDescriptor, JavaClass javaClass) {
        List fields = javaClass.getFields();
        if (javaClass.getSuperJavaClass() != null) {
            this.findRequirements(classCache, componentDescriptor, javaClass.getSuperJavaClass());
        }
        for (JavaField field : fields) {
            ComponentRequirement cr;
            DocletTag tag = field.getTagByName(PLEXUS_REQUIREMENT_TAG);
            if (tag == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>(tag.getNamedParameterMap());
            String requirementClass = field.getType().getFullyQualifiedName();
            boolean isMap = requirementClass.equals(Map.class.getName()) || requirementClass.equals(Collection.class.getName());
            try {
                isMap = isMap || Collection.class.isAssignableFrom(Class.forName(requirementClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean isList = requirementClass.equals(List.class.getName());
            String hint = this.getParameter(parameters, PLEXUS_ROLE_HINT_PARAMETER);
            if (isMap || isList) {
                cr = new ComponentRequirementList();
                String hintList = this.getParameter(parameters, PLEXUS_ROLE_HINT_LIST_PARAMETER);
                if (hintList != null) {
                    String[] hintArr = hintList.split(",");
                    ((ComponentRequirementList)cr).setRoleHints(Arrays.asList(hintArr));
                }
            } else {
                cr = new ComponentRequirement();
                cr.setRoleHint(hint);
            }
            String role = this.getParameter(parameters, PLEXUS_ROLE_PARAMETER);
            if (role == null) {
                cr.setRole(requirementClass);
            } else {
                cr.setRole(role);
            }
            String optional = this.getParameter(parameters, PLEXUS_OPTIONAL_PARAMETER);
            cr.setOptional(Boolean.parseBoolean(optional));
            cr.setFieldName(field.getName());
            if (isMap || isList) {
                if (hint != null || role == null) continue;
                JavaClass roleClass = classCache.getClassByName(role);
                if (role.indexOf(46) == -1 && StringUtils.isEmpty((String)QDoxComponentGleaner.getPackage(roleClass))) {
                    role = QDoxComponentGleaner.getPackage(javaClass) + "." + roleClass.getName();
                }
                cr.setRole(role);
                this.findExtraParameters(PLEXUS_REQUIREMENT_TAG, parameters);
            }
            componentDescriptor.addRequirement(cr);
        }
    }

    private void findConfiguration(XmlPlexusConfiguration configuration, JavaClass javaClass) throws ComponentGleanerException {
        List fields = javaClass.getFields();
        if (javaClass.getSuperJavaClass() != null) {
            this.findConfiguration(configuration, javaClass.getSuperJavaClass());
        }
        for (JavaField field : fields) {
            HashMap<String, String> parameters;
            String defaultValue;
            DocletTag tag = field.getTagByName(PLEXUS_CONFIGURATION_TAG);
            if (tag == null || (defaultValue = (String)(parameters = new HashMap<String, String>(tag.getNamedParameterMap())).remove(PLEXUS_DEFAULT_VALUE_PARAMETER)) == null) continue;
            String name = this.deHump(field.getName());
            XmlPlexusConfiguration c = new XmlPlexusConfiguration(name);
            c.setValue(defaultValue);
            configuration.addChild((PlexusConfiguration)c);
            this.findExtraParameters(PLEXUS_CONFIGURATION_TAG, parameters);
        }
    }

    private void findExtraParameters(String tagName, Map<String, String> parameters) {
        for (String string : parameters.keySet()) {
        }
    }

    private String getParameter(Map<String, String> parameters, String parameter) {
        String value = parameters.remove(parameter);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }
}

