/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender.javamail;

import java.util.Properties;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.mailsender.javamail.AbstractJavamailMailSender;
import org.codehaus.plexus.mailsender.javamail.DummySSLSocketFactory;
import org.codehaus.plexus.util.StringUtils;

public class JndiJavamailMailSender
extends AbstractJavamailMailSender {
    private String jndiSessionName;

    public Session getSession() throws MailSenderException {
        try {
            InitialContext ctx = new InitialContext();
            Session s = (Session)ctx.lookup(this.jndiSessionName);
            Properties props = new Properties(s.getProperties());
            if ("smtps".equals(props.getProperty("mail.transport.protocol"))) {
                props.put("mail.smtps.socketFactory.class", DummySSLSocketFactory.class.getName());
            }
            if (StringUtils.isEmpty((String)props.getProperty("mail.smtp.timeout"))) {
                props.put("mail.smtp.timeout", "30000");
            }
            return Session.getInstance((Properties)props, null);
        }
        catch (NamingException e) {
            throw new MailSenderException("Can't get mail session for component '" + this.jndiSessionName + "'.", (Throwable)e);
        }
    }

    public String getJndiSessionName() {
        return this.jndiSessionName;
    }

    public void setJndiSessionName(String jndiSessionName) {
        this.jndiSessionName = jndiSessionName;
    }
}

