/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.smb1;

import java.util.Date;
import jcifs.smb1.smb1.Info;
import jcifs.smb1.smb1.ServerMessageBlock;
import jcifs.smb1.util.Hexdump;

class SmbComQueryInformationResponse
extends ServerMessageBlock
implements Info {
    private int fileAttributes = 0;
    private long lastWriteTime = 0L;
    private long serverTimeZoneOffset;
    private int fileSize = 0;

    SmbComQueryInformationResponse(long serverTimeZoneOffset) {
        this.serverTimeZoneOffset = serverTimeZoneOffset;
        this.command = (byte)8;
    }

    @Override
    public int getAttributes() {
        return this.fileAttributes;
    }

    @Override
    public long getCreateTime() {
        return this.lastWriteTime + this.serverTimeZoneOffset;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime + this.serverTimeZoneOffset;
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        if (this.wordCount == 0) {
            return 0;
        }
        this.fileAttributes = SmbComQueryInformationResponse.readInt2(buffer, bufferIndex);
        this.lastWriteTime = SmbComQueryInformationResponse.readUTime(buffer, bufferIndex += 2);
        this.fileSize = SmbComQueryInformationResponse.readInt4(buffer, bufferIndex += 4);
        return 20;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComQueryInformationResponse[" + super.toString() + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",fileSize=" + this.fileSize + "]");
    }
}

