/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class ComposableRecordReader
extends BaseRecordReader {
    private RecordReader[] readers;

    public ComposableRecordReader(RecordReader ... readers) {
        this.readers = readers;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public Collection<Writable> next() {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (this.hasNext()) {
            for (RecordReader reader : this.readers) {
                ret.addAll(reader.next());
            }
        }
        this.invokeListeners(ret);
        return ret;
    }

    @Override
    public boolean hasNext() {
        Boolean readersHasNext = true;
        for (RecordReader reader : this.readers) {
            readersHasNext = readersHasNext != false && reader.hasNext();
        }
        return readersHasNext;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void close() throws IOException {
        for (RecordReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        for (RecordReader reader : this.readers) {
            reader.setConf(conf);
        }
    }

    @Override
    public Configuration getConf() {
        int n = 0;
        RecordReader[] recordReaderArray = this.readers;
        int n2 = recordReaderArray.length;
        if (n < n2) {
            RecordReader reader = recordReaderArray[n];
            return reader.getConf();
        }
        return null;
    }

    @Override
    public void reset() {
        for (RecordReader reader : this.readers) {
            reader.reset();
        }
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Generating records from DataInputStream not supported for ComposableRecordReader");
    }
}

