/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition;

import java.util.List;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class BooleanCondition
implements Condition {
    private final Type type;
    private final Condition[] conditions;

    public BooleanCondition(Type type, Condition ... conditions) {
        if (conditions == null || conditions.length < 1) {
            throw new IllegalArgumentException("Invalid input: conditions must be non-null and have at least 1 element");
        }
        switch (type) {
            case NOT: {
                if (conditions.length == 1) break;
                throw new IllegalArgumentException("Invalid input: NOT conditions must have exactly 1 element");
            }
            case XOR: {
                if (conditions.length == 2) break;
                throw new IllegalArgumentException("Invalid input: XOR conditions must have exactly 2 elements");
            }
        }
        this.type = type;
        this.conditions = conditions;
    }

    @Override
    public boolean condition(List<Writable> list) {
        switch (this.type) {
            case AND: {
                for (Condition c : this.conditions) {
                    boolean thisCond = c.condition(list);
                    if (thisCond) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Condition c : this.conditions) {
                    boolean thisCond = c.condition(list);
                    if (!thisCond) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return !this.conditions[0].condition(list);
            }
            case XOR: {
                return this.conditions[0].condition(list) ^ this.conditions[1].condition(list);
            }
        }
        throw new RuntimeException("Unknown condition type: " + (Object)((Object)this.type));
    }

    @Override
    public boolean conditionSequence(List<List<Writable>> sequence) {
        switch (this.type) {
            case AND: {
                for (Condition c : this.conditions) {
                    boolean thisCond = c.conditionSequence(sequence);
                    if (thisCond) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Condition c : this.conditions) {
                    boolean thisCond = c.conditionSequence(sequence);
                    if (!thisCond) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                return !this.conditions[0].conditionSequence(sequence);
            }
            case XOR: {
                return this.conditions[0].conditionSequence(sequence) ^ this.conditions[1].conditionSequence(sequence);
            }
        }
        throw new RuntimeException("Unknown condition type: " + (Object)((Object)this.type));
    }

    @Override
    public void setInputSchema(Schema schema) {
        for (Condition c : this.conditions) {
            c.setInputSchema(schema);
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.conditions[0].getInputSchema();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BooleanCondition(").append((Object)this.type);
        for (Condition c : this.conditions) {
            sb.append(",").append(c.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static Condition AND(Condition ... conditions) {
        return new BooleanCondition(Type.AND, conditions);
    }

    public static Condition OR(Condition ... conditions) {
        return new BooleanCondition(Type.OR, conditions);
    }

    public static Condition NOT(Condition condition) {
        return new BooleanCondition(Type.NOT, condition);
    }

    public static Condition XOR(Condition first, Condition second) {
        return new BooleanCondition(Type.XOR, first, second);
    }

    public static enum Type {
        AND,
        OR,
        NOT,
        XOR;

    }
}

