/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.string;

import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class StringRegexColumnCondition
extends BaseColumnCondition {
    private final String regex;

    public StringRegexColumnCondition(String columnName, String regex) {
        this(columnName, regex, DEFAULT_SEQUENCE_CONDITION_MODE);
    }

    public StringRegexColumnCondition(String columnName, String regex, SequenceConditionMode sequenceConditionMode) {
        super(columnName, sequenceConditionMode);
        this.regex = regex;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return writable.toString().matches(this.regex);
    }

    @Override
    public String toString() {
        return "StringRegexColumnCondition(colName=\"" + this.column + "\",regex=\"" + this.regex + "\")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringRegexColumnCondition)) {
            return false;
        }
        StringRegexColumnCondition other = (StringRegexColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringRegexColumnCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        return result;
    }

    public String getRegex() {
        return this.regex;
    }
}

