/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.filter;

import java.util.List;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public abstract class BaseColumnFilter
implements Filter {
    protected Schema schema;
    protected final String column;
    protected int columnIdx;

    protected BaseColumnFilter(String column) {
        this.column = column;
    }

    @Override
    public boolean removeExample(List<Writable> writables) {
        return this.removeExample(writables.get(this.columnIdx));
    }

    @Override
    public boolean removeSequence(List<List<Writable>> sequence) {
        for (List<Writable> c : sequence) {
            if (!this.removeExample(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
        this.columnIdx = schema.getIndexOfColumn(this.column);
    }

    public abstract boolean removeExample(Writable var1);
}

