/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.filter;

import java.util.List;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class FilterInvalidValues
implements Filter {
    private Schema schema;
    private final boolean filterAnyInvalid;
    private final String[] columnsToFilterIfInvalid;
    private int[] columnIdxs;

    public FilterInvalidValues() {
        this.filterAnyInvalid = true;
        this.columnsToFilterIfInvalid = null;
    }

    public FilterInvalidValues(String ... columnsToFilterIfInvalid) {
        if (columnsToFilterIfInvalid == null || columnsToFilterIfInvalid.length == 0) {
            throw new IllegalArgumentException("Cannot filter 0/null columns: columns to filter on must be specified");
        }
        this.columnsToFilterIfInvalid = columnsToFilterIfInvalid;
        this.filterAnyInvalid = false;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
        if (!this.filterAnyInvalid) {
            this.columnIdxs = new int[this.columnsToFilterIfInvalid.length];
            for (int i = 0; i < this.columnsToFilterIfInvalid.length; ++i) {
                this.columnIdxs[i] = schema.getIndexOfColumn(this.columnsToFilterIfInvalid[i]);
            }
        }
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public boolean removeExample(List<Writable> writables) {
        if (writables.size() != this.schema.numColumns()) {
            return true;
        }
        if (!this.filterAnyInvalid) {
            for (int i : this.columnIdxs) {
                ColumnMetaData meta = this.schema.getMetaData(i);
                if (meta.isValid(writables.get(i))) continue;
                return true;
            }
        } else {
            int nCols = this.schema.numColumns();
            for (int i = 0; i < nCols; ++i) {
                ColumnMetaData meta = this.schema.getMetaData(i);
                if (meta.isValid(writables.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeSequence(List<List<Writable>> sequence) {
        for (List<Writable> c : sequence) {
            if (!this.removeExample(c)) continue;
            return true;
        }
        return false;
    }
}

