/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.Writable;

public class IntegerMetaData
implements ColumnMetaData {
    private final Integer minAllowedValue;
    private final Integer maxAllowedValue;

    public IntegerMetaData() {
        this(null, null);
    }

    public IntegerMetaData(Integer min, Integer max) {
        this.minAllowedValue = min;
        this.maxAllowedValue = max;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Integer;
    }

    @Override
    public boolean isValid(Writable writable) {
        int value;
        try {
            value = Integer.parseInt(writable.toString());
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (this.minAllowedValue != null && value < this.minAllowedValue) {
            return false;
        }
        return this.maxAllowedValue == null || value <= this.maxAllowedValue;
    }

    @Override
    public IntegerMetaData clone() {
        return new IntegerMetaData(this.minAllowedValue, this.maxAllowedValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntegerMetaData(");
        if (this.minAllowedValue != null) {
            sb.append("minAllowed=").append(this.minAllowedValue);
        }
        if (this.maxAllowedValue != null) {
            if (this.minAllowedValue != null) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.maxAllowedValue);
        }
        sb.append(")");
        return sb.toString();
    }

    public Integer getMinAllowedValue() {
        return this.minAllowedValue;
    }

    public Integer getMaxAllowedValue() {
        return this.maxAllowedValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerMetaData)) {
            return false;
        }
        IntegerMetaData other = (IntegerMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minAllowedValue = this.getMinAllowedValue();
        Integer other$minAllowedValue = other.getMinAllowedValue();
        if (this$minAllowedValue == null ? other$minAllowedValue != null : !((Object)this$minAllowedValue).equals(other$minAllowedValue)) {
            return false;
        }
        Integer this$maxAllowedValue = this.getMaxAllowedValue();
        Integer other$maxAllowedValue = other.getMaxAllowedValue();
        return !(this$maxAllowedValue == null ? other$maxAllowedValue != null : !((Object)this$maxAllowedValue).equals(other$maxAllowedValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegerMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minAllowedValue = this.getMinAllowedValue();
        result = result * 59 + ($minAllowedValue == null ? 43 : ((Object)$minAllowedValue).hashCode());
        Integer $maxAllowedValue = this.getMaxAllowedValue();
        result = result * 59 + ($maxAllowedValue == null ? 43 : ((Object)$maxAllowedValue).hashCode());
        return result;
    }
}

