/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class LongMetaData
implements ColumnMetaData {
    private final Long min;
    private final Long max;

    public LongMetaData() {
        this(null, null);
    }

    public LongMetaData(Long min, Long max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Long;
    }

    @Override
    public boolean isValid(Writable writable) {
        long value;
        if (writable instanceof IntWritable || writable instanceof LongWritable) {
            value = writable.toLong();
        } else {
            try {
                value = Long.parseLong(writable.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (this.min != null && value < this.min) {
            return false;
        }
        return this.max == null || value <= this.max;
    }

    @Override
    public LongMetaData clone() {
        return new LongMetaData(this.min, this.max);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongMetaData(");
        if (this.min != null) {
            sb.append("minAllowed=").append(this.min);
        }
        if (this.max != null) {
            if (this.min != null) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.max);
        }
        sb.append(")");
        return sb.toString();
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongMetaData)) {
            return false;
        }
        LongMetaData other = (LongMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$min = this.getMin();
        Long other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        Long this$max = this.getMax();
        Long other$max = other.getMax();
        return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        Long $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        return result;
    }
}

