/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.quality;

import java.beans.ConstructorProperties;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.quality.columns.ColumnQuality;
import org.datavec.api.transform.schema.Schema;

public class DataQualityAnalysis {
    private Schema schema;
    private List<ColumnQuality> columnQualityList;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.schema.numColumns();
        int maxNameLength = 0;
        for (String s : this.schema.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append(String.format("%-10s", "quality")).append("details").append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.schema.getName(i);
            ColumnType type = this.schema.getType(i);
            ColumnQuality columnQuality = this.columnQualityList.get(i);
            boolean pass = columnQuality.getCountInvalid() == 0L && columnQuality.getCountMissing() == 0L;
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(String.format("%-10s", pass ? "ok" : "FAIL")).append(columnQuality).append("\n");
        }
        return sb.toString();
    }

    @ConstructorProperties(value={"schema", "columnQualityList"})
    public DataQualityAnalysis(Schema schema, List<ColumnQuality> columnQualityList) {
        this.schema = schema;
        this.columnQualityList = columnQualityList;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<ColumnQuality> getColumnQualityList() {
        return this.columnQualityList;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setColumnQualityList(List<ColumnQuality> columnQualityList) {
        this.columnQualityList = columnQualityList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataQualityAnalysis)) {
            return false;
        }
        DataQualityAnalysis other = (DataQualityAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        List<ColumnQuality> this$columnQualityList = this.getColumnQualityList();
        List<ColumnQuality> other$columnQualityList = other.getColumnQualityList();
        return !(this$columnQualityList == null ? other$columnQualityList != null : !((Object)this$columnQualityList).equals(other$columnQualityList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataQualityAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        List<ColumnQuality> $columnQualityList = this.getColumnQualityList();
        result = result * 59 + ($columnQualityList == null ? 43 : ((Object)$columnQualityList).hashCode());
        return result;
    }
}

