/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.writable.Writable;

public class SplitMaxLengthSequence
implements SequenceSplit {
    private final int maxSequenceLength;
    private final boolean equalSplits;
    private Schema inputSchema;

    public SplitMaxLengthSequence(int maxSequenceLength, boolean equalSplits) {
        this.maxSequenceLength = maxSequenceLength;
        this.equalSplits = equalSplits;
    }

    @Override
    public List<List<List<Writable>>> split(List<List<Writable>> sequence) {
        int n = sequence.size();
        if (n <= this.maxSequenceLength) {
            return Collections.singletonList(sequence);
        }
        int splitSize = this.equalSplits ? (n % this.maxSequenceLength == 0 ? n / this.maxSequenceLength : n / this.maxSequenceLength + 1) : this.maxSequenceLength;
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        ArrayList<List<Writable>> current = new ArrayList<List<Writable>>(splitSize);
        for (List<Writable> step : sequence) {
            if (current.size() >= splitSize) {
                out.add(current);
                current = new ArrayList(splitSize);
            }
            current.add(step);
        }
        out.add(current);
        return out;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }
}

