/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.split;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.writable.Writable;

public class SequenceSplitTimeSeparation
implements SequenceSplit {
    private final String timeColumn;
    private final long timeQuantity;
    private final TimeUnit timeUnit;
    private final long separationMilliseconds;
    private int timeColumnIdx = -1;
    private Schema schema;

    public SequenceSplitTimeSeparation(String timeColumn, long timeQuantity, TimeUnit timeUnit) {
        this.timeColumn = timeColumn;
        this.timeQuantity = timeQuantity;
        this.timeUnit = timeUnit;
        this.separationMilliseconds = TimeUnit.MILLISECONDS.convert(timeQuantity, timeUnit);
    }

    @Override
    public List<List<List<Writable>>> split(List<List<Writable>> sequence) {
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        long lastTimeStepTime = Long.MIN_VALUE;
        ArrayList<List<Writable>> currentSplit = null;
        for (List<Writable> timeStep : sequence) {
            long currStepTime = timeStep.get(this.timeColumnIdx).toLong();
            if (lastTimeStepTime == Long.MIN_VALUE || currStepTime - lastTimeStepTime > this.separationMilliseconds) {
                if (currentSplit != null) {
                    out.add(currentSplit);
                }
                currentSplit = new ArrayList<List<Writable>>();
            }
            currentSplit.add(timeStep);
            lastTimeStepTime = currStepTime;
        }
        out.add(currentSplit);
        return out;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.timeColumn)) {
            throw new IllegalStateException("Invalid state: schema does not have column with name \"" + this.timeColumn + "\"");
        }
        if (inputSchema.getMetaData(this.timeColumn).getColumnType() != ColumnType.Time) {
            throw new IllegalStateException("Invalid input schema: schema column \"" + this.timeColumn + "\" is not a time column." + " (Is type: " + (Object)((Object)inputSchema.getMetaData(this.timeColumn).getColumnType()) + ")");
        }
        this.timeColumnIdx = inputSchema.getIndexOfColumn(this.timeColumn);
        this.schema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    public String toString() {
        return "SequenceSplitTimeSeparation(timeColumn=\"" + this.timeColumn + "\",timeQuantity=" + this.timeQuantity + ",timeUnit=" + (Object)((Object)this.timeUnit) + ")";
    }
}

