/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.window;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.reduce.IReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.writable.Writable;

public class ReduceSequenceByWindowTransform
implements Transform {
    private IReducer reducer;
    private WindowFunction windowFunction;
    private Schema inputSchema;

    public ReduceSequenceByWindowTransform(IReducer reducer, WindowFunction windowFunction) {
        this.reducer = reducer;
        this.windowFunction = windowFunction;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (inputSchema != null && !(inputSchema instanceof SequenceSchema)) {
            throw new IllegalArgumentException("Invalid input: input schema must be a SequenceSchema");
        }
        inputSchema = this.windowFunction.transform(inputSchema);
        Schema oneStepSchema = this.reducer.transform(inputSchema);
        List<String> columnNames = oneStepSchema.getColumnNames();
        List<ColumnMetaData> meta = oneStepSchema.getColumnMetaData();
        return new SequenceSchema(columnNames, meta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.windowFunction.setInputSchema(inputSchema);
        this.reducer.setInputSchema(this.windowFunction.transform(inputSchema));
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("ReduceSequenceByWindownTransform can only be applied on sequences");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        List<List<List<Writable>>> sequenceAsWindows = this.windowFunction.applyToSequence(sequence);
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<List<Writable>> window : sequenceAsWindows) {
            List<Writable> reduced = this.reducer.reduce(window);
            out.add(reduced);
        }
        return out;
    }
}

