/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;

public class CategoricalToIntegerTransform
extends BaseTransform {
    private String columnName;
    private int columnIdx = -1;
    private List<String> stateNames;
    private Map<String, Integer> statesMap;

    public CategoricalToIntegerTransform(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        super.setInputSchema(inputSchema);
        this.columnIdx = inputSchema.getIndexOfColumn(this.columnName);
        ColumnMetaData meta = inputSchema.getMetaData(this.columnName);
        if (!(meta instanceof CategoricalMetaData)) {
            throw new IllegalStateException("Cannot convert column \"" + this.columnName + "\" from categorical to one-hot: column is not categorical (is: " + (Object)((Object)meta.getColumnType()) + ")");
        }
        this.stateNames = ((CategoricalMetaData)meta).getStateNames();
        this.statesMap = new HashMap<String, Integer>(this.stateNames.size());
        for (int i = 0; i < this.stateNames.size(); ++i) {
            this.statesMap.put(this.stateNames.get(i), i);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        int i = 0;
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> typesIter = origMeta.iterator();
        ArrayList<String> outNames = new ArrayList<String>(origNames.size());
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(outNames.size());
        while (namesIter.hasNext()) {
            String s = namesIter.next();
            ColumnMetaData t = typesIter.next();
            outNames.add(s);
            if (i++ == this.columnIdx) {
                int nClasses = this.stateNames.size();
                newMeta.add(new IntegerMetaData(0, nClasses - 1));
                continue;
            }
            newMeta.add(t);
        }
        return schema.newSchema(outNames, newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int idx = this.getColumnIdx();
        int n = this.stateNames.size();
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == idx) {
                String str = w.toString();
                Integer classIdx = this.statesMap.get(str);
                if (classIdx == null) {
                    throw new RuntimeException("Unknown state (index not found): " + str);
                }
                out.add(new IntWritable(classIdx));
                continue;
            }
            out.add(w);
        }
        return out;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalToIntegerTransform)) {
            return false;
        }
        CategoricalToIntegerTransform other = (CategoricalToIntegerTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        if (this.getColumnIdx() != other.getColumnIdx()) {
            return false;
        }
        List<String> this$stateNames = this.getStateNames();
        List<String> other$stateNames = other.getStateNames();
        if (this$stateNames == null ? other$stateNames != null : !((Object)this$stateNames).equals(other$stateNames)) {
            return false;
        }
        Map<String, Integer> this$statesMap = this.getStatesMap();
        Map<String, Integer> other$statesMap = other.getStatesMap();
        return !(this$statesMap == null ? other$statesMap != null : !((Object)this$statesMap).equals(other$statesMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoricalToIntegerTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        result = result * 59 + this.getColumnIdx();
        List<String> $stateNames = this.getStateNames();
        result = result * 59 + ($stateNames == null ? 43 : ((Object)$stateNames).hashCode());
        Map<String, Integer> $statesMap = this.getStatesMap();
        result = result * 59 + ($statesMap == null ? 43 : ((Object)$statesMap).hashCode());
        return result;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public Map<String, Integer> getStatesMap() {
        return this.statesMap;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public void setStatesMap(Map<String, Integer> statesMap) {
        this.statesMap = statesMap;
    }

    @Override
    public String toString() {
        return "CategoricalToIntegerTransform(columnName=" + this.getColumnName() + ", columnIdx=" + this.getColumnIdx() + ", stateNames=" + this.getStateNames() + ", statesMap=" + this.getStatesMap() + ")";
    }
}

