/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.integer;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;

public class IntegerMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final int scalar;

    public IntegerMathOpTransform(String columnName, MathOp mathOp, int scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof IntegerMetaData)) {
            throw new IllegalStateException("Column is not an integer column");
        }
        IntegerMetaData meta = (IntegerMetaData)oldColumnType;
        Integer minValue = meta.getMinAllowedValue();
        Integer maxValue = meta.getMaxAllowedValue();
        if (minValue != null) {
            minValue = this.doOp(minValue);
        }
        if (maxValue != null) {
            maxValue = this.doOp(maxValue);
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            Integer temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new IntegerMetaData(minValue, maxValue);
    }

    private int doOp(int input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new IntWritable(this.doOp(columnWritable.toInt()));
    }

    @Override
    public String toString() {
        return "IntegerMathOpTransform(mathOp=" + (Object)((Object)this.mathOp) + ",scalar=" + this.scalar + ")";
    }
}

