/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResource {
    private String resourceName;
    private static Logger log = LoggerFactory.getLogger(ClassPathResource.class);

    public ClassPathResource(String resourceName) {
        if (resourceName == null) {
            throw new IllegalStateException("Resource name can't be null");
        }
        this.resourceName = resourceName;
    }

    private URL getUrl() {
        URL url;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null) {
            loader = ClassPathResource.class.getClassLoader();
        }
        if ((url = loader.getResource(this.resourceName)) == null) {
            if (this.resourceName.startsWith("/") ? (url = loader.getResource(this.resourceName.replaceFirst("[\\\\/]", ""))) != null : (url = loader.getResource("/" + this.resourceName)) != null) {
                return url;
            }
            throw new IllegalStateException("Resource '" + this.resourceName + "' cannot be found.");
        }
        return url;
    }

    public File getFile() throws FileNotFoundException {
        URL url = this.getUrl();
        if (this.isJarURL(url)) {
            try {
                url = this.extractActualUrl(url);
                File file = File.createTempFile("datavec_temp", "file");
                file.deleteOnExit();
                ZipFile zipFile = new ZipFile(url.getFile());
                ZipEntry entry = zipFile.getEntry(this.resourceName);
                if (entry == null) {
                    if (this.resourceName.startsWith("/")) {
                        entry = zipFile.getEntry(this.resourceName.replaceFirst("/", ""));
                        if (entry == null) {
                            throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                        }
                    } else {
                        throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                    }
                }
                long size = entry.getSize();
                InputStream stream = zipFile.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(file);
                byte[] array = new byte[1024];
                int rd = 0;
                long bytesRead = 0L;
                do {
                    rd = stream.read(array);
                    outputStream.write(array, 0, rd);
                } while ((bytesRead += (long)rd) < size);
                outputStream.flush();
                outputStream.close();
                stream.close();
                zipFile.close();
                return file;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            URI uri = new URI(url.toString().replaceAll(" ", "%20"));
            return new File(uri.getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            return new File(url.getFile());
        }
    }

    private boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol) || "code-source".equals(protocol) && url.getPath().contains("!/");
    }

    private URL extractActualUrl(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException var5) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL("file:" + jarFile);
            }
        }
        return jarUrl;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        URL url = this.getUrl();
        if (this.isJarURL(url)) {
            try {
                url = this.extractActualUrl(url);
                ZipFile zipFile = new ZipFile(url.getFile());
                ZipEntry entry = zipFile.getEntry(this.resourceName);
                if (entry == null) {
                    if (this.resourceName.startsWith("/")) {
                        entry = zipFile.getEntry(this.resourceName.replaceFirst("/", ""));
                        if (entry == null) {
                            throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                        }
                    } else {
                        throw new FileNotFoundException("Resource " + this.resourceName + " not found");
                    }
                }
                InputStream stream = zipFile.getInputStream(entry);
                return stream;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        File srcFile = this.getFile();
        return new FileInputStream(srcFile);
    }
}

